
#include "axTransport.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "MDM.h"
#include "axStatusCodes.h"
#include "axConstants.h"
#include <math.h>


MDMSerial* mdm;
int socket;
char *temp_buff;
int buff_size;


/************************************************************************************************/
/*getEpoch()                                                                                    */
/*                                                                                              */
/*This method should return the number of seconds since January 1st 1970.                       */
/*                                                                                              */
/*returns long value in seconds                                                                 */
/************************************************************************************************/

long getEpoch()
{
    return (long)0;
}


/**************************************************************************************************/
/*ax_print()                                                                                     */
/*                                                                                               */
/*A wrapper method that will allow you to direct the output to a particular stream. Most of the  */
/*time the output will just go to printf/std. out. This is called by the axAgent library to print*/
/*error and debug messages. It is reccomended to include processing for the integers AX_DEBUG_MSG*/
/*and AX_ERROR_MSG as the library will frequently use these options if configured.               */
/*                                                                                               */
/* msgType: allows for an integer value to control how the data is displayed or written          */
/* msg: a pointer to a string containing the data to be printed                                  */
/************************************************************************************************/
void ax_print(int msgType, char *msg)
{
    switch(msgType) {
        case AX_DEBUG_MSG:
            printf("DEBUG: %s\r\n", msg);
            break;
        case AX_ERROR_MSG:
            printf("ERR: %s\r\n", msg);
            break;
    }

}
/************************************************************************************************/
/*sys_delay()                                                                                   */
/*                                                                                              */
/*A wrapper method that is meant to induce a delay on the system that it running it. Used mostly*/
/*to implement timeouts.                                                                        */
/*                                                                                              */
/*                                                                                              */
/*                                                                                              */
/************************************************************************************************/
void sys_delay(int seconds)
{
    wait_ms(seconds*1000);
}

/************************************************************************************************/
/*randInt()											*/
/*												*/
/*This function is an abstraction function and should be populated with a call to the host's    */
/*equivalent of the random function. 								*/
/************************************************************************************************/
int randInt()
{
    //call to the local create random method.
    return rand();
}

/************************************************************************************************/
/*seedRand()                                                                                     */
/*                                                                                              */
/*This function is an abstraction function and should be populated with a call to the host's    */
/*equivalent of the function that seeds the random number generator                             */
/************************************************************************************************/

int seedRand()
{
    srand(12345);
    return AX_OK;
}

/*************************************************************************************************/
/*net_socketInit()                                                                               */
/*                                                                                               */
/*This method provides a convenient way to call code that initializes the socket before it is    */
/*actually called to open. For example, it could initialize a holder object that you code or set */
/*options on the socket itself. The return will be a code that could be passed up through the    */
/*HTTP library and to the error stream.                                                          */
/*************************************************************************************************/
int net_socketInit(ax_socket *sock)
{
    int retVal=AX_UNKNOWN;
    buff_size=0;
    temp_buff=NULL;
    return retVal;
}

/*************************************************************************************************/
/*net_socketOpen()                                                                               */
/*                                                                                               */
/*This function opens a network port and connects to it. The connection point is defined by server*/
/*and port in the arguments. A reference to the port should be stored in the sock structure. If  */
/*the secure flag is set to AX_TRUE your code should enable TLS or SSL at this stage.            */
/*                                                                                               */
/*************************************************************************************************/
int net_socketOpen(ax_socket *sock, char *server, int port, int secure)
{
    int retVal=AX_UNKNOWN;
    const char* host = server;
    mdm = MDMSerial::getMDMInstance();
    socket = mdm->socketSocket(MDMParser::IPPROTO_TCP);
    if (socket >= 0) {
        mdm->socketSetBlocking(socket, 5000);
        mdm->socketConnect(socket, host, port);
        retVal=AX_OK;
    } else {
        retVal=AX_NET_ERR_UNABLE_TO_CONNECT;
    }

    return retVal;
}
/*************************************************************************************************/
/*net_socketWrite()                                                                             */
/*                                                                                               */
/*This function is used to write the data to a network port that has already been open and is    */
/*connected. As usual the ax_socket struct should contain a reference to your port that you wish */
/*to write to. Data contains the data to be written and size describes how long the data is.     */
/*                                                                                               */
/*************************************************************************************************/
int net_socketWrite(ax_socket *sock, char *data, int size)
{
    int retVal=AX_OK;
    int fullsz=size+1;
    if(buff_size==0) {
        temp_buff=(char *)calloc(fullsz, sizeof(char));
        int wrt=snprintf(temp_buff, fullsz, "%s", data);
        buff_size++;
    } else {
        int total=strlen(temp_buff)+fullsz;
        char *temp=(char *)calloc(total, sizeof(char));
        snprintf(temp, total, "%s%s", temp_buff, data);
        free(temp_buff);
        temp_buff=temp;
        buff_size++;
    }
    return retVal;
}


/*************************************************************************************************/
/*net_socketFlush()                                                                              */
/*                                                                                               */
/*This function will be called to handle writing all the data out to a network port. This function*/
/*may not be needed depending on your system. The single argument is a pointer to a struct that  */
/*should contain the necessary references to the port on your local system.                      */
/*                                                                                               */
/*************************************************************************************************/
int net_socketFlush(ax_socket *sock)
{
    int retVal=AX_UNKNOWN;
    int size=strlen(temp_buff);
    retVal = mdm->socketSend(socket, temp_buff, size); //Wr
    free(temp_buff);
    buff_size=0;
    return retVal;
}
/*************************************************************************************************/
/*net_socketClose()                                                                              */
/*                                                                                               */
/*This function will be called to handle a socket close operation. It is used primarily by the   */
/*axHTTP part of the library. The single argument is pointer to a structure that should contain  */
/*the necessary references to the port on your local system.                                     */
/*Override the source in this function to close a network port                                   */
/*************************************************************************************************/
int net_socketClose(ax_socket *sock)
{

    mdm->socketClose(socket);
    mdm->socketFree(socket);

    return AX_OK;
}

/*************************************************************************************************/
/*net_socketRead()                                                                               */
/*                                                                                               */
/*This function is a wrapper function that will read returned data from a previous web call. It  */
/*is assumed that any connection related to ax_socket will have already been established. The    */
/*function should read the data and store it into the *data pointer, then populate the number of */
/*bytes read in the size variable. The axHTTP library will handle parsing and making sense of the*/
/*data that it is provided. The timeout will be passed as a parameter but is not implemented by  */
/*any of the calling libraries, implement it here or pass to another local function if available.*/
/*************************************************************************************************/
int net_socketRead(ax_socket *sock, int timeout, unsigned char *buffer, int bufferSz, int *readSz)
{
    int retVal=AX_UNKNOWN;
    retVal = mdm->socketRecv(socket, (char*)buffer, bufferSz);
    readSz = &retVal;
    retVal=AX_OK;
    return retVal;
}

/*************************************************************************************************/
/*scm_download_req()                                                                              */
/*                                                                                                */
/*This function will be called whenever an egress message is recieved with a file download command*/
/*You can write the code in the function to handle the file immediately OR store the structure for*/
/*later processing. The latter is preferable as this request may prevent the network port from    */
/*being closed in a timely fashion.                                                              */
/*                                                                                               */
/*************************************************************************************************/
int scm_download_req(ax_package *request)
{

    return AX_OK;
}


/*************************************************************************************************/
/*scm_file_write()                                                                               */
/*                                                                                               */
/*This function will be called whenever a file download is requested from the system. Override the*/
/*function to direct the output to serial or a file system or other storage device of your choice*/
/*The parameters to the function will be filled in when it's called by the toolkit               */
/*                                                                                               */
/*char *filename: Just what it sounds like, the file name of the file                            */
/*char *data: The actual data of the file.                                                       */
/*int length: The number of bytes received                                                       */
/*ax_package_instruction *downloadInfo: a struct containing filename/path etc.                   */
/*************************************************************************************************/
int scm_file_write(char *filename, char *data, int length, ax_package_instruction *downloadInfo)
{

    return AX_OK;
}

/*************************************************************************************************/
/*data_item_write()                                                                              */
/*                                                                                               */
/*If a set data item command is recieved from the platform server this function will be called to*/
/*handle it each time. The function is here to allow for external data to be modified as needed. */
/*It could toggle a pin and light up an led or set a global variable in another thread.          */
/*                                                                                               */
/*char *name: The name of the data item on the platform                                          */
/*int ax_type: {AX_STRING|AX_ANALoG|AX_DIGITAL} indicates whether the sValue or dValue parameter */
/*             will have the intended data.                                                      */
/*char *sValue: if ax_type==AX_STRING then this will be a pointer to a valid cstring             */
/*int dValue: if ax_type==AX_ANLOG|AX_DIGITAL this value will be populated. It should be not be  */
/*            checked if the type is AX_STRING                                                   */
/*************************************************************************************************/
int data_item_write(char *name, char *sValue, int dValue, int ax_type)
{
/*
//these variables are declared in main.cpp
    extern int oil_level;
    extern int oil_level2;

    if (ax_type==AX_ANALOG) {
        if (strstr(name, "oil_level2"))
            printf("STATUS: Received data item from platform: OL1");
        oil_level2=dValue;
        return AX_OK;
    } else if (strstr(name, "oil_level")) {
        printf("STATUS: Received data item from platform: OL2");
        oil_level=dValue;
    }
*/
return AX_OK;
}

/*************************************************************************************************/
/*data_item_request()                                                                            */
/*                                                                                               */
/*This function is called whenever the platform requests a data item's current value. Since this */
/*library is designed to run as it's own thread it does not maintain a list of data items and    */
/*values. The implementation of this function should call an appropriate library or check an input*/
/*then create a dataItem set and send it immediately or on the next ping.                        */
/*                                                                                               */
/*char *name, the name of the data item being requested                                          */
/*                                                                                               */
/*************************************************************************************************/
int data_item_request(char *name)
{

    return AX_OK;
}

/***************************************************************************************************/
/***********************************************{Custom helper methods}****************************/
