
#ifndef _AXSTATUSCODES_H_
#define _AXSTATUSCODES_H_

#define AX_ERROR -1                         //A General Error has occurred
#define AX_OK 0                             //Operation Success
#define AX_UNKNOWN -42                      //An unknown error has occurred. Functions are normally initialized to return this value. The function should change it before returning it.
#define AX_ARGNULL -999                     //An argument passed to the function was left null
#define AX_OUT_OF_RANGE -998                //An argument passed to the function was out of range
#define AX_DI_UNKNOWN_TYPE -997             //An argument passed to the function indicating the Data Item type was incorrect
#define AX_CONFLICTING_ARG -996             //Two arguments passed to a function describing the same object have conflicting values e.g. arg1(string)=="fubar"; arg2(strlength)==0, The string fubar is obviously longer than 0
#define AX_ARG_EMPTY  -995		    //An argument passed to the function was a string but it was empty eg mystring="". This will be thrown when a value is required. 

#define AX_NET_ERR_UNABLE_TO_CONNECT  700       //Call to open the TCP port to IP or hostname has failed. Is the port open? IP contactable?
#define AX_NET_ERR_PORT_WRITE         701       //The program was unable to write data onto the socket.
#define AX_NET_ERR_HEADER_WRITE       702       //a write error occurred while writing the HTTP headers
#define AX_NET_ERR_DATA_WRITE         703       //a write error occurred while writing the HTTP data/body
#define AX_NET_ERR_TIMEOUT            704       //A timeout occurred while waiting for a response.
#define AX_NET_PORT_INVALID           705       //The port that was specified is larger than 65536 or less than 0
#define AX_NET_DNS_ERROR	      706	//There was an error resolving the name of the platform server
#define AX_NET_MORE_WAITING	      707	//Thrown when the data written to the port does not equal the amount of data that was requested to be written.

#define AX_GEN_STR_TRUNC                604     //the string to be stored was too long and has been truncated, This is a warning only.
#define AX_EGR_JSON_PARSE_FAIL          800     //The egress message that was returned did not have the necessary fields
#define AX_GEN_PARSE_ERR                603     //A general parsing failure has occured. Invalid JSON will cause this error. 


//The following codes are used for an optional Queueing implementation example. 
#define AX_GEN_QUEUE_FULL               600     //The queue is full and cannot accept more items. Item was not added. Enable overwrite or empty the queue
#define AX_GEN_QUEUE_ITEM_EXISTS        601     //The item you tried to enqueue already exists in the queue.
#define AX_GEN_QUEUE_EMPTY              602     //The queue is empty, thrown on a dequeue operation




#endif

