#ifndef _AXSETTINGS_H_
#define _AXSETTINGS_H_

/************************************************************************************/
/* axSettings.h                                                                     */
/* �2013 Axeda Corporation                                                          */
/*                                                                                  */
/*This file defines default settings for the domain objects. Most of the time they  */
/*define how many characters will be allocated to a particular field. The library   */
/*automatically truncate strings that are too long and will return an error code.   */
/************************************************************************************/

//define max string sizes for certain structs
#define AX_ALM_NAME_S 50				//Defines how many characters are allocated for an alarm name           (ax_alarm.alarmName)
#define AX_ALM_DESC_S 50        //Defines how many characters are allocated for an alarm description    (ax_alarm.alarmDescription)
#define AX_ALM_CAUSE_S 50       //Defines how many characters are allocated for an alarm cause          (ax_alarm.alarmCause)
#define AX_ALM_REAS_S 50        //Defines how many characters are allocated for an alarm reason         (ax_alarm.alarmReason)

#define AX_DN_NAME_S  50        //Defines how many characters are allocated for a dataNode name         (ax_dataNode.name)
#define AX_DN_SV_S    50        //Defines how many characters are allocated for a dataNode string       (ax_datanode.sValue)

#define AX_EVT_NAME_S 50        //Defines how many characters are allocated for an event name           (ax_event.name)
#define AX_EVT_DESC_S 50        //Defines how many characters are allocated for an devent description   (ax_event.description)

#define AX_MSID_DID_S 50         //Defines how many characters are allocated for a device ID             (ax_deviceID.deviceId)
#define AX_MSID_MDL_S 50        //Defines how many characters are allocated for a model number          (ax_deviceID.model)
#define AX_MSID_SER_S 50        //Defines how many characters are allocated for a serial number         (ax_deviceID.serial)
#define AX_MSID_TEN_S 50        //Defines how many characters are allocated for a tenant ID             (ax_deviceID.tenant)

#define AX_FILE_NAME_S 50      //Defines how many characters are allocated for a file name              (ax_file.name)
#define AX_FILE_HINT_S 50      //Defines how many characters are allocated for a file hint              (ax_file.hint)
#define AX_FILE_ID_S   50      //Defines how many characters are allocated for a file ID                (ax_file.fileID)
                                                                                                       
#define AX_PLAT_HOST_S 50      //Defines how many characters are allocated for a platform hostname      (ax_platform.hostname)

#define AX_PKGI_FID_S   50     //Defines how many characters are allocated for a package file ID        (ax_package_instruction.file_id)
#define AX_PKGI_PATH_S  50     //Defines how many characters are allocated for a package path           (ax_package_instruction.path)
#define AX_PKGI_FNAME_S 50     //Defines how many characters are allocated for a package file name      (ax_package_instruction.filename)

#define AX_PKG_ID_S   50       //Defines how many characters are allocated for a package ID             (ax_package.packageID)

#define AX_NET_BUFF_S 1024     //Defines how many characters are allocated for an HTTP response         (ax_alarm.alarmReason)



#endif

