#include "axTransport.h"
#include "mbed.h"
#include "GPS.h"
#include "MDM.h"
#include "axToolkit.h"
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>

#define SIMPIN      NULL
#define APN         "wap.cingular"
#define USERNAME    "wap@cingulargprs.com"
#define PASSWORD    "cingular1"

//------------------------------------------------------------------------------------

#define MODEL   "nlr_ublox_c027"
#define SERIAL_NUM  "YOUR SERIAL"
#define HOST    "toolbox-connect.axeda.com"
#define PORT    (80)
#define PING    (700)

axToolkitConfig cfg;
//Initial AMMP configuration
axToolkitConfig *initConfig(axToolkitConfig *cfg)

{
    char *model = MODEL;
    char *serial = SERIAL_NUM;
    const char *host = HOST;
    int port = PORT;

    printf("STATUS: Initializing AMMP configuration\r\n");
    ax_createPlatform(&cfg->platform, host,NULL,port);
    cfg->platform.secure=AX_FALSE;
    cfg->platform.verify=AX_FALSE;
    cfg->platform.ping_rate=PING;

    printf("STATUS: Initializing device ID\r\n");
    ax_data_createModelSerialDeviceId(&cfg->thisDevice, model, serial, NULL);
    cfg->conf_recv_timeout = 5000;
    cfg->conf_queue_size=10;
    cfg->first_run=AX_FALSE;
    cfg->debug_mode=AX_TRUE;
    cfg->print_mem=AX_FALSE;

    return cfg;
}
//Sends event item to platform
int sendEvent(char* name, char* desc)
{
    int res=0;

    printf("STATUS: Beginning event send\r\n");
    ax_event *events[1];
    events[0] = NULL;
    events[0]=(ax_event *)calloc(1,sizeof(ax_event));
    res = ax_data_createEvent(events[0],name,desc,0,AX_NO_PRIORITY);
    printf("STATUS: Event item creation result: %d\r\n",res);

    ax_platform_sendEvents(&cfg.platform, &cfg.thisDevice,events,1);
    free(events[0]);

    return AX_OK;
}
//Sends location item to platform
int sendLoc(double lat, double lon)
{
    int res=0;

    printf("STATUS: Beginning location send\r\n");
    ax_location *location[1];
    location[0] = NULL;
    location[0]=(ax_location *)calloc(1,sizeof(ax_location));
    res = ax_data_createLocation(location[0],lat,lon,0,0,AX_NO_PRIORITY);
    printf("STATUS: Location item creation result: %d\r\n",res);

    printf("STATUS: Sending data items to platform\r\n");
    ax_platform_sendLocations(&cfg.platform, &cfg.thisDevice,location,1);
    free(location[0]);

    return AX_OK;
}

//Sends data item to platform
int sendData(char *name, double value)
{
    int res=0;

    printf("STATUS: Beginning data send\r\n");
    ax_dataSet *data[1];
    data[0] = NULL;
    data[0]=(ax_dataSet *)calloc(1,sizeof(ax_dataSet));
    res = ax_data_createDataItem(data[0],name,AX_ANALOG,NULL,value,0,AX_NO_PRIORITY);
    printf("STATUS: Data item creation result: %d\r\n",res);

    printf("STATUS: Sending data items to platform\r\n");
    ax_platform_sendData(&cfg.platform, &cfg.thisDevice,data,1);
    free(data[0]);

    return AX_OK;
}

//global variables for data items (server egress)
int tank1=0;
int tank2=0;

int main(void)
{
////////////////////////////////////INIT///////////////////////////////////////////////////
    bool abort=false;
    int ret;
    char buf[2048] = "";

    // Create the GPS object
#if 0  // use GPSI2C class
    GPSI2C gps;
#else   // or GPSSerial class 
    GPSSerial gps;
#endif

    //Create modem object
    MDMSerial mdm;
   // mdm.setDebug(4); //Uncomment this line to get modem debug messages

    //initialize the modem
    MDMParser::DevStatus devStatus = {};
    MDMParser::NetStatus netStatus = {};
    bool mdmOk = mdm.init(SIMPIN, &devStatus);
    mdm.dumpDevStatus(&devStatus);
    if (mdmOk) {
        //wait until we are connected
        mdmOk = mdm.registerNet(&netStatus);
        mdm.dumpNetStatus(&netStatus);
    }
    initConfig(&cfg);
    MDMParser::IP ip = mdm.join(APN,USERNAME,PASSWORD);
    if (ip == NOIP) {
        printf("ERROR - Modem unable to join internet connection\r\n");
        abort=true;
    }
    if ((ret = ax_platform_register(&cfg.platform, &cfg.thisDevice))!=AX_OK) {
        printf("ERROR - Could not register with Axeda Platform\r\n");
    }
//////////////////////////////////////////////////////////////////////////////////////////
    printf("SMS and GPS Loop\r\n");
    char link[128] = "";
    char data[128] = "";
    unsigned int i = 0xFFFFFFFF;
    const int wait = 2000;
    //DigitalOut led(LED1);
    while (!abort) {

/////////////////////////////////POLL/////////////////////////////////////////////////////
        /*   if ((ret = ax_platform_ping(&cfg.platform, &cfg.thisDevice))!=AX_OK) {
               printf("ERROR - Lost connectivity with Axeda Platform\r\n");
           }*/
        sprintf(data, "Current data values: \r\nTank level 1: %d\r\nTank level 2: %d\r\n", tank1, tank2);
//////////////////////////////////GPS/////////////////////////////////////////////////////
        while ((ret = gps.getMessage(buf, sizeof(buf))) > 0) {
            int len = LENGTH(ret);
            //printf("NMEA: %.*s\r\n", len-2, msg);
            if ((PROTOCOL(ret) == GPSParser::NMEA) && (len > 6)) {
                if (!strncmp("$GPGLL", buf, 6)) {
                    double la = 0, lo = 0;
                    char ch;
                    if (gps.getNmeaAngle(1,buf,len,la) &&
                            gps.getNmeaAngle(3,buf,len,lo) &&
                            gps.getNmeaItem(6,buf,len,ch) && ch == 'A') {
                        printf("STATUS: GPS Location: %.5f %.5f\r\n", la, lo);
                        sprintf(link, "I am here!\n"
                          "https://maps.google.com/?q=%.5f,%.5f", la, lo);
                        sendLoc(la, lo); 
                    }
                } else if (!strncmp("$GPGGA", buf, 6)) {
                    double alt = 0;
                    if (gps.getNmeaItem(9,buf,len,alt)) // altitude msl [m]
                        printf("STATUS: GPS Altitude: %.1f\r\n", alt);

                } else if (!strncmp("$GPVTG", buf, 6)) {
                    double s = 0;
                    if (gps.getNmeaItem(7,buf,len,s)) // speed [km/h]
                        printf("STATUS: GPS Speed: %.1f\r\n", s);
                }
            }
        }

/////////////////////////////SMS//////////////////////////////////////////////////////////////
        int ix[8];
        int n = mdm.smsList("REC UNREAD", ix, 8);
        if (8 < n) n = 8;
        while (0 < n--) {
            char num[32];
            char msg[140];
            printf("STATUS: Unread SMS at index %d\r\n", ix[n]);
            if (mdm.smsRead(ix[n], num, msg, sizeof(msg))) {
                printf("STATUS: Got SMS from \"%s\" with text \"%s\"\r\n", num, msg);
                sendEvent(num, msg);
                printf("STATUS: Delete SMS at index %d\r\n", ix[n]);
                mdm.smsDelete(ix[n]);
                // provide a reply
                const char* reply = "Howdy from u-blox and Axeda!";
                if (strstr(msg, /*w*/"here are you"))
                    reply = *link ? link : "Don't know - no GPS data yet"; // reply wil location link
                else if (strstr(msg, /*s*/"hutdown"))
                    abort = true, reply = "Good night, and good luck";
                else if (strstr(msg, /*f*/"ill1")) {
                    reply = ("Increased fill - sending data to platform!");
                    if (tank1<9) {
                        tank1+=2;
                    }
                    sendData("oil_level", tank1);
                } else if (strstr(msg, /*f*/"ill2")) {
                    reply = ("Increased fill - sending data to platform!");
                    if (tank2<9) {
                        tank2+=2;
                    }
                    sendData("oil_level2", tank2);
                } else if (strstr(msg, /*d*/"ipense1")) {
                    reply = ("Dispensed from tank 1 - sending data to platform!");
                    if (tank1>=2) {
                        tank1-=2;
                    }
                    sendData("oil_level", tank1);
                } else if (strstr(msg, /*d*/"ispense2")) {
                    reply = ("Dipensed from tank 2 - sending data to platform!");
                    if (tank2>=2) {
                        tank2-=2;
                    }
                    sendData("oil_level2", tank2);
                }

                printf("Send SMS reply \"%s\" to \"%s\"\r\n", reply, num);
                mdm.smsSend(num, reply);
            }
        }
///////////////////////////////NETCHECK////////////////////////////////////////////////////////
        if (mdmOk && (i++ == 5000/wait)) {
            i = 0;
            // check the network status
            if (mdm.checkNetStatus(&netStatus)) {
                mdm.dumpNetStatus(&netStatus, fprintf, stdout);
            }
        }
        wait_ms(wait);
    }
//////////////////////////////CLOSE///////////////////////////////////////////////////////////////
    gps.powerOff();
    mdm.powerOff();
    return 0;
}

