#pragma once

#ifndef _AXTRANSPORT_H_
#define _AXTRANSPORT_H_

#include "axTypes.h"

/************************************************************************************/
/*Struct ax_socket                                                                  */
/*                                                                                  */
/*The following structure is meant as a mechanism to pass information from a network*/
/*function to the next. It can be overridden with machine specific code, provided   */
/* that all of the functions in this file prefixed with net_ can handle it correctly*/
/************************************************************************************/


#ifdef __cplusplus 
  extern "C" {
#endif
typedef struct {

    
}ax_socket;


long getEpoch();
void ax_print(int msgType, char *msg);
int randInt();
int seedRand();

void sys_delay(int seconds);

int net_socketInit(ax_socket *sock);
int net_socketOpen(ax_socket *sock, char *server, int port, int secure);
int net_socketWrite(ax_socket *sock, char *data, int size);
int net_socketClose(ax_socket *sock);
int net_socketFlush(ax_socket *sock);
int net_socketRead(ax_socket *sock, int timeout, unsigned char *buffer, int bufferSz, int *readSz);

int scm_download_req(ax_package *request);
int scm_file_write(char *filename, char *data, int length, ax_package_instruction *downloadInfo);
int data_item_write(char *name, char *sValue, int dValue, int ax_type);
int data_item_request(char *name);


#ifdef __cplusplus 
 }
#endif


#endif

