/************************************************************************************/
/* axPlatform.h                                                                    */
/* 2013 Axeda Corporation                                                          */
/*                                                                                  */
/* Defines methods for interaction with end points on the Axeda Platform.  This     */
/* is a device independent implementation which can be applied to any device that   */
/* supports ANSI C.                                                                 */
/************************************************************************************/

#ifndef AXPLATFORM_H
#define AXPLATFORM_H

#include "axTypes.h"
#include <stdio.h>


#define END_BASE     0
#define END_DATA     1
#define END_AGENTS   2
#define END_FILES    3
#define END_FILED    4
#define END_PACKAGES 5
#define END_STATUS   6
#define END_REG	     7

#define BUFF_ALARMS     0
#define BUFF_EVENTS     1
#define BUFF_DATA       2
#define BUFF_LOCATIONS  3

#define PKG_QUEUED      0
#define PKG_STARTED     1
#define PKG_SUCCESS     2
#define PKG_FAILURE     3

#ifdef __cplusplus 
  extern "C" {
#endif


int ax_platform_send(ax_platform *cloud, ax_deviceID *device, ax_dataSet *dataItems[], int numDataSets, ax_alarm *alarms[], int numAlarms, ax_event *events[], int numEvents, ax_location *locations[], int numLocations);
int ax_platform_sendData(ax_platform *cloud, ax_deviceID *device, ax_dataSet *dataItems[], int numDataSets);
int ax_platform_sendAlarms(ax_platform *cloud, ax_deviceID *device, ax_alarm *alarms[], int numAlarms);
int ax_platform_sendEvents(ax_platform *cloud, ax_deviceID *device, ax_event *events[], int numEvents);
int ax_platform_sendLocations(ax_platform *cloud, ax_deviceID *device, ax_location *locations[], int numLocations);

int ax_platform_register(ax_platform *cloud, ax_deviceID *device);
int ax_platform_ping(ax_platform *cloud, ax_deviceID *device);
int ax_platform_upload(ax_platform *cloud, ax_deviceID *device, ax_file *file);
int ax_platform_download(ax_platform *cloud, ax_deviceID *device, ax_package_instruction *instr);

int ax_platform_setPkgStatus(ax_platform *cloud, ax_deviceID *device, char *pkgID, int status, char *errorMsg);
int ax_platform_setPkgStatusStarted(ax_platform *cloud, ax_deviceID *device, char *pkgID);
int ax_platform_setPkgStatusQueued(ax_platform *cloud, ax_deviceID *device, char *pkgID);
int ax_platform_setPkgStatusSuccess(ax_platform *cloud, ax_deviceID *device, char *pkgID);
int ax_platform_setPkgStatusFailed(ax_platform *cloud, ax_deviceID *device, char *pkgID, char *errorMsg);
/*******************************************************************************************************/
/*The following functions are internal only and should never need to be called outside of this library*/
/*****************************************************************************************************/
char *encodeAgentID(ax_deviceID *device, char *buff);
char *getResource(char *endPointBuff, ax_deviceID *device, int resourceType);
char *getDataResource(char *endPointBuff, ax_deviceID *device);
char *getAgentResource(char *endPointBuff, ax_deviceID *device);
char *getFileResource(char *endPointBuff, ax_deviceID *device);
char *getRegistrationResource(char *endPointBuff, ax_deviceID *device);
char *getFileDownloadResource(char *endPointBuff, ax_deviceID *device, char *fileID);
char *getPackageUpdateResource(char *endPointBuff, ax_deviceID *device, char *packageID);

char *getContentType(char *contentBuff, int type);
char *getGeneralType(char *contentBuff);

#ifdef __cplusplus
  }
#endif

#endif

