/* mbed Microcontroller Library
* Copyright (c) 2006-2013 ARM Limited
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
#include "mbed.h"
#include "cc3000.h"
#include "main.h"
#include "TSISensor.h"
#include "MMA8451Q.h"  //accelerometer
#include "TCPSocketConnection.h"


using namespace mbed_cc3000;

/* cc3000 module declaration specific for user's board */
#if (MY_BOARD == WIFI_SHEILD_ADAFRUIT)
cc3000 wifi(PTA12, PTA5, PTD0, SPI(PTD2, PTD3, PTD1),  PORTA_IRQn);
Serial pc(USBTX, USBRX); // tx, rx
#else

#endif

tUserFS user_info;

char str[512];

MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);

DigitalOut rled(LED_RED);
DigitalOut gled(LED_GREEN); 
// DO NOT Use LED_BLUE - pin PTD1 already in use by WiFi chip



/**
*  \brief Print cc3000 information
*  \param none
*  \return none
*/
void print_cc3000_info() {
    uint8_t myMAC[8];

    printf("MAC address + cc3000 info \r\n");
    wifi.get_user_file_info((uint8_t *)&user_info, sizeof(user_info));
    wifi.get_mac_address(myMAC);
    printf(" MAC address %02x:%02x:%02x:%02x:%02x:%02x \r\n \r\n", myMAC[0], myMAC[1], myMAC[2], myMAC[3], myMAC[4], myMAC[5]);

    printf(" FTC        %i \r\n",user_info.FTC);
    printf(" PP_version %i.%i \r\n",user_info.PP_version[0], user_info.PP_version[1]);
    printf(" SERV_PACK  %i.%i \r\n",user_info.SERV_PACK[0], user_info.SERV_PACK[1]);
    printf(" DRV_VER    %i.%i.%i \r\n",user_info.DRV_VER[0], user_info.DRV_VER[1], user_info.DRV_VER[2]);
    printf(" FW_VER     %i.%i.%i \r\n",user_info.FW_VER[0], user_info.FW_VER[1], user_info.FW_VER[2]);
}

/**
*  \brief Connect to SSID with a timeout
*  \param ssid     Name of SSID
*  \param key      Password
*  \param sec_mode Security mode
*  \return none
*/
void connect_to_ssid(char *ssid, char *key, unsigned char sec_mode) {
    printf("Connecting to SSID: %s. Timeout is 10s. \r\n",ssid);
    if (wifi.connect_to_AP((uint8_t *)ssid, (uint8_t *)key, sec_mode) == true) {
        printf(" Connected. \r\n");
    } else {
        printf(" Connection timed-out (error). Please restart. \r\n");
        while(1);
  }
}


/**
*  \brief HTTP client demo
*  \param  none
*  \return int
*/
int main() {

    rled = 1;
    gled = 1;
    TSISensor touchSensor;
    const char* SERVER_ADDRESS = "216.34.120.52";   //IP address for toolbox-stage-connect.axeda.com is 216.34.120.53
                                                    //IP address for toolbox-connect.axeda.com is 216.34.120.52
    const int SERVER_PORT = 80;
    char *MODEL = "Freescale";
    char *SERIAL_NUM = "nlr__jrogers_axeda_com___6243311"; 
    int http_cmd_sz=800;
    char http_cmd[http_cmd_sz]; 
    int buffer_sz=300;  
    char buffer[buffer_sz];  
    int returnCode = 0;
    int weight=0;
    TCPSocketConnection socket;
    
        
    float accels[3];
    float resting,reading;
    float THRESHOLD = 0.15;
    float position;
    
    
    pc.printf("Starting up...\n");


    pc.printf("Before wifi.start...\n");
    wifi.start(0);
    printf("cc3000 HTTP client demo. \r\n");
    print_cc3000_info();

    printf("Attempting SSID Connection. \r\n");

    wifi._wlan.ioctl_set_connection_policy(0, 0, 0);

    connect_to_ssid(SSID, AP_KEY, AP_SECURITY);

    printf("send DHCP request \r\n");
    gled =0;
    
    
    while (wifi.is_dhcp_configured() == false) {

         wait_ms(500);
         printf("  Waiting for dhcp to be set. \r\n");

    }
    
    gled = 1; rled = 0;

    tNetappIpconfigRetArgs ipinfo2;
    wifi.get_ip_config(&ipinfo2); // data is returned in the ipinfo2 structure
    printf("DHCP assigned IP Address = %d.%d.%d.%d \r\n", ipinfo2.aucIP[3], ipinfo2.aucIP[2], ipinfo2.aucIP[1], ipinfo2.aucIP[0]);
    printf("  subnet mask            = %d.%d.%d.%d \r\n", ipinfo2.aucSubnetMask[3], ipinfo2.aucSubnetMask[2], ipinfo2.aucSubnetMask[1], ipinfo2.aucSubnetMask[0]);
    printf("  gateway                = %d.%d.%d.%d \r\n", ipinfo2.aucDefaultGateway[3], ipinfo2.aucDefaultGateway[2], ipinfo2.aucDefaultGateway[1], ipinfo2.aucDefaultGateway[0]);
    printf("  DNS IP Address         = %d.%d.%d.%d \r\n", ipinfo2.aucDNSServer[3], ipinfo2.aucDNSServer[2], ipinfo2.aucDNSServer[1], ipinfo2.aucDNSServer[0]);



    
    wait(0.7);
    acc.getAccAllAxis( accels );
    resting = abs(accels[0]) + abs(accels[1]) + abs(accels[2]);
    printf("Set up resting accelerometer - %.2f\r\n", resting);
    wait(0.1);


        
    while(1)
    {

        acc.getAccAllAxis( accels );
        reading = abs(accels[0]) + abs(accels[1]) + abs(accels[2]);
        if ( abs( resting - reading ) > THRESHOLD ){
            wait(0.1);
            position = touchSensor.readPercentage();
            printf( "BUMPED  resting %.2f   read %.2f  position %.2f \r\n", resting, reading, position );
            rled = 1;
            gled = 1;
            
            printf("Before connect\r\n");
            //socket.connect(SERVER_ADDRESS, SERVER_PORT);
            while ( socket.connect(SERVER_ADDRESS, SERVER_PORT)  < 0) {
              printf("Unable to connect to (%s) on port (%d) \r\n", SERVER_ADDRESS, SERVER_PORT);
                wait(1);
                printf(" - retring to connect");
            }
            printf( "connected");
            weight = position * 300;
            printf("\n%d\n", weight);
           snprintf(http_cmd, http_cmd_sz, "POST /ammp/data/1/%s!%s HTTP/1.1\r\nContent-type: application/json\r\nContent-Length: 52\r\n\r\n{\"data\":[{\"dataItems\":{\"weight\":%d}}]}\r\n\r\n", MODEL, SERIAL_NUM, weight);
            socket.send_all(http_cmd, http_cmd_sz-1);
     
            returnCode = socket.receive(buffer, buffer_sz-1);
        
            buffer[returnCode] = '\0';
            printf("Sent->%s<-\r\n",http_cmd);
            printf("Received %d chars from server:\n\r%s\n", returnCode, buffer);
            
            socket.close();
            printf("Socket closed\r\n");
            rled = 0;
            gled = 0;
        
        //memset null
        memset(buffer, '\0', buffer_sz);
        memset(http_cmd, '\0', http_cmd_sz);
        }

    }
    
}
