#include "USBHostMouse.h"

#ifdef _USB_DBG
#define USB_DBG(...) do{fprintf(stderr,"[%s@%d] ",__PRETTY_FUNCTION__,__LINE__);fprintf(stderr,__VA_ARGS__);fprintf(stderr,"\n");} while(0);
#define USB_DBG_HEX(A,B) debug_hex(A,B)
void debug_hex(uint8_t* buf, int size);
#else
#define USB_DBG(...) while(0)
#define USB_DBG_HEX(A,B) while(0)
#endif

#define USB_TEST_ASSERT(A) while(!(A)){fprintf(stderr,"\n\n%s@%d %s ASSERT!\n\n",__PRETTY_FUNCTION__,__LINE__,#A);exit(1);};
#define USB_TEST_ASSERT_FALSE(A) USB_TEST_ASSERT(!(A))

#define USB_INFO(...) do{fprintf(stderr,__VA_ARGS__);}while(0);

USBHostMouse::USBHostMouse() {
    host = USBHost::getHostInst();
    init();
}

void USBHostMouse::init() {
    dev = NULL;
    int_in = NULL;
    onUpdate = NULL;
    onButtonUpdate = NULL;
    onXUpdate = NULL;
    onYUpdate = NULL;
    onZUpdate = NULL;
    report_id = 0;
    dev_connected = false;
    mouse_device_found = false;
    mouse_intf = -1;
    
    buttons = 0;
    x = 0;
    y = 0;
    z = 0;
}

bool USBHostMouse::connected() {
    return dev_connected;
}

bool USBHostMouse::connect() {

    if (dev_connected) {
        return true;
    }
    
    for (uint8_t i = 0; i < MAX_DEVICE_CONNECTED; i++) {
        if ((dev = host->getDevice(i)) != NULL) {

            if(host->enumerate(dev, this))
                break;
            
            if (mouse_device_found) {
                
                int_in = dev->getEndpoint(mouse_intf, INTERRUPT_ENDPOINT, IN);
                USB_DBG("int_in=%p", int_in);
                if (!int_in)
                    break;
                
                USB_INFO("New Mouse device: VID:%04x PID:%04x [dev: %p - intf: %d]\n", dev->getVid(), dev->getPid(), dev, mouse_intf);
                dev->setName("Mouse", mouse_intf);
                host->registerDriver(dev, mouse_intf, this, &USBHostMouse::init);
                
                //int_in->attach(this, &USBHostMouse::rxHandler);
                host->interruptRead(dev, int_in, report, int_in->getSize(), false);
                
                dev_connected = true;
                return true;
            }
        }
    }
    init();
    return false;
}

/*virtual*/ void USBHostMouse::setVidPid(uint16_t vid, uint16_t pid)
{
    USB_DBG("vid:%04x pid:%04x", vid, pid);
    // we don't check VID/PID for mouse driver
}

/*virtual*/ bool USBHostMouse::parseInterface(uint8_t intf_nb, uint8_t intf_class, uint8_t intf_subclass, uint8_t intf_protocol) //Must return true if the interface should be parsed
{
    USB_DBG("intf: %d class: %02x %02x %02x", intf_nb, intf_class, intf_subclass, intf_protocol);
    if ((mouse_intf == -1) &&
        (intf_class == HID_CLASS) &&
        (intf_subclass == 0x01) &&
        (intf_protocol == 0x02)) {
        mouse_intf = intf_nb;
        return true;
    }
    return false;
}

/*virtual*/ bool USBHostMouse::useEndpoint(uint8_t intf_nb, ENDPOINT_TYPE type, ENDPOINT_DIRECTION dir) //Must return true if the endpoint will be used
{
    USB_DBG("intf_nb=%d type=%d dir=%d", intf_nb, type, dir);

    if (intf_nb == mouse_intf) {
        if (type == INTERRUPT_ENDPOINT && dir == IN) {
            mouse_device_found = true;
            return true;
        }
    }
    return false;
}

#if 0
void USBHostMouse::setup() {
    dev = host->getDevice(0);
    if (dev->getClass() == HUB_CLASS) {
        for(int i = 1; ; i++) {
            dev = host->getDevice(i);
            if (dev == NULL) {
                break;
            }
            if (enumeration(dev)) {
                break;
            }
        }
        USB_TEST_ASSERT(ep_int_in);
    } else {
        ep_int_in = NULL;
    }
}

bool USBHostMouse::enumeration(USBDeviceConnected* dev) {
    // config descriptor
    uint8_t desc[4];
    int rc = host->controlRead(dev, 0x80, GET_DESCRIPTOR, 2<<8, 0, desc, 4);
    USB_TEST_ASSERT(rc == USB_TYPE_OK);
    USB_DBG_HEX(desc, 4);

    int TotalLength = desc[2]|desc[3]<<8;
    uint8_t* buf = new uint8_t[TotalLength];
    rc = host->controlRead(dev, 0x80, GET_DESCRIPTOR, 2<<8, 0, buf, TotalLength);
    USB_TEST_ASSERT(rc == USB_TYPE_OK);
    //USB_DBG_HEX(buf, TotalLength);
    bool found = false;
    for(int i = 0; i < TotalLength; ) {
        int Length = buf[i];
        uint8_t DescriptorType = buf[i+1];
        if (DescriptorType == 0x04) { // interface
            InterfaceDescriptor* desc = reinterpret_cast<InterfaceDescriptor*>(buf+i);
            if (desc->bInterfaceClass == 0x03) {
                found = true;
            }
        } else if (DescriptorType == 0x05) { // endpoint
            EndpointDescriptor* desc = reinterpret_cast<EndpointDescriptor*>(buf+i);
            if (desc->bmAttributes == 0x03 &&
                (desc->bEndpointAddress & 0x80)) { // interrupt in
                ep_int_in = new USBEndpoint;
                ep_int_in->setDevice(dev);
                ep_int_in->setAddress(desc->bEndpointAddress);
                ep_int_in->setSize(desc->wMaxPacketSize);
            }
        }
        USB_DBG_HEX(buf+i, Length);
        i += Length;
    }
    delete[] buf;
    if (!found) {
        return false;
    }
    int config = 1;
    host->controlWrite(dev, 0x00, SET_CONFIGURATION, config, 0, NULL, 0);
    wait_ms(100);
    return true;
}
#endif

