/************************************************************************************/
/* axSerializer.c                                                                   */
/* 2013 Axeda Corporation                                                          */
/*                                                                                  */
/* Defines methods for transposing the data in domain objects into a serialized     */
/* encoding for transmission to the Platform Endpoint. This is a platform independent*/
/* implementation that can be applied to any device that supports ANSI C.           */
/*                                                                                  */
/************************************************************************************/

#ifndef AXSERIALIZER_H
#define AXSERIALIZER_H

#include "cJSON.h"
#include "axTypes.h"
#include "axConstants.h"

extern int terse_enable;

#ifdef __cplusplus 
  extern "C" {
#endif


cJSON *dataSet2JSON(ax_dataSet *di[], int len, int terse_on);
cJSON *getRegistrationJSON(ax_deviceID *device, int pingRate);
cJSON *getPKGStatusJSON(int status, char *error, int priority, int time, int terse_on);
cJSON *AlarmsToJSON(ax_alarm *alarms[], int len, int terse_on);
cJSON *eventsToJSON(ax_event *events[], int len, int terse_on);
cJSON *locationsToJSON(ax_location *locations[], int len, int terse_on);

#ifdef __cplusplus
  }
#endif

#endif

