/************************************************************************************/
/* axDomain.h                                                                       */
/* 2013 Axeda Corporation                                                          */
/*                                                                                  */
/* Defines methods for creation and interaction with Axeda domain constructs. This  */
/* is a device independent implementation which can be applied to any device that   */
/* supports ANSI C.                                                                 */
/************************************************************************************/

#ifndef AXDOMAIN_H
#define AXDOMAIN_H

#include "axTypes.h"
#include "axConstants.h"
#include "axStatusCodes.h"

#ifdef __cplusplus 
  extern "C" {
#endif

int ax_data_createAlarm(ax_alarm *alm, char *alName, char *alDescription, int alSeverity, char *cause, char *reason, int timeOccured, int priority);
int ax_data_createEvent(ax_event *evt, char *name, char *description, int timeOccured, int priority);
int ax_data_createRegistration();
int ax_data_createLocation(ax_location *loc, double lat, double lon, double alt, int timeAcquired, int priority);
int ax_data_createModelSerialDeviceId(ax_deviceID *device, char *model, char *serial, char *tenant);
int ax_createFile(ax_file *file, char *name, char *hint, int size, unsigned char *data);

int ax_createPlatform(ax_platform *axedaCloud, char *hostname, int ip[], int port);


int ax_data_createDataItem(ax_dataSet *destDI, char *diName, int diType, char *stringValue, double numericValue, int timeAcquired, int priority);
int ax_data_createAnalogDataItem(ax_dataSet *destDI, char *diName, double value, int timeAcquired, int priority);
int ax_data_createDigitalDataItem(ax_dataSet *destDI, char *diName, double value, int timeAcquired, int priority);
int ax_data_createStringDataItem(ax_dataSet *destDI, char *diName, char *value, int timeAcquired, int priority);

int ax_data_createSet(ax_dataSet *set, int acquisitionTime, int priority);

int ax_data_addToSet(ax_dataSet *set, char *diName, int diType, char *stringValue, double numericValue);
int ax_data_addStringToSet(ax_dataSet *set, char *diName, char *value);
int ax_data_addAnalogToSet(ax_dataSet *set, char *diName, double value);
int ax_data_addDigitalToSet(ax_dataSet *set, char *diName, double value);
int ax_data_destroySet(ax_dataSet *set);

int ax_pkg_createPackageInstruction(ax_package_instruction *package, int instruction_type, char *file_id, char *path, char *filename);
int ax_pkg_createPackage(ax_package *package, char *pkgID, int time, int priority);
int ax_pkg_addDLInstruction(ax_package *pkg, char *file_id, char *path, char *filename);
int ax_pkg_destroyPackage(ax_package *pkg);

#ifdef __cplusplus
  }
#endif
#endif

