/* mbed USBHost Library
 * Copyright (c) 2006-2013 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
 
#pragma once
#include "USBHostTypes.h"
#include "USBDeviceConnected.h"
class USBDeviceConnected;

class USBEndpoint {
public:
    USBEndpoint() : data01_toggle(DATA0),address(0),MaxPacketSize(8) {
        dev = NULL;
    }
    void setDevice(USBDeviceConnected* _dev) { dev = _dev; }
    void setState(uint8_t st){}; // dummy
    void setLengthTransferred(int len) { transferred = len; };
    void setSize(int size) { MaxPacketSize = size; }
    void setType(ENDPOINT_TYPE _type) { type = _type; };
    void setAddress(uint8_t addr) { address = addr; }
    void setData01(uint8_t data01) { data01_toggle = data01; }

    USBDeviceConnected* getDevice() { return dev; }
    ENDPOINT_TYPE getType() { return type; };
    int getLengthTransferred() { return transferred; }
    uint8_t getAddress(){ return address; };
    int getSize() { return MaxPacketSize; }
    ENDPOINT_DIRECTION getDir() { return (address & 0x80) ? IN : OUT; }
    uint8_t getData01() { return data01_toggle; }
    void toggleData01() {
        data01_toggle = (data01_toggle == DATA0) ? DATA1 : DATA0;
    }

private:
    ENDPOINT_TYPE type;
    ENDPOINT_DIRECTION dir;
    USBDeviceConnected* dev;
    uint8_t data01_toggle; // DATA0,DATA1
    uint8_t address;
    int transferred;
    int MaxPacketSize;
};
