/* ========================================================================== */
/*                                                                            */
/*   axToolkit.h                                                              */
/*   2013 Axeda Corporation                                                  */
/*                                                                            */
/*   This file will include all necessary libraries and functions to use the  */
/*   AMMP C Toolkit in your project.                                          */
/* ========================================================================== */

#ifndef AXTOOLKIT_H
#define AXTOOLKIT_H

#include "axTypes.h"
#include "axConstants.h"
#include "axStatusCodes.h"
#include "axDomain.h"
#include "axPlatform.h"
#include "axTransport.h"
//#include "axHTTP.h"


typedef struct
{
    ax_deviceID thisDevice;         //A struct containing the device serial and model numbers  -- How the device identifies itself
    ax_platform platform;           //A struct containing the target platform URL, port number etc. -- Where to send the data
    int     conf_ping_rate;         //ping rate of the device in SECONDS
    int     first_run;              //a flag to indicate if this is a first run of the agent
    int     conf_recv_timeout;      //how long we wait to receive a response from the server
    int     conf_queue_size;        //the size of the queues used to store data items/locations/events/alarms while operating
    int     debug_mode;             //prints out extra messages to the standard out. Also adds HTTP header with a sequential value to all packets.
    int     print_mem;              //prints out heap memory statistics to the standard out.
} axToolkitConfig;

extern int debugEnabled;

#ifdef __cplusplus 
  extern "C" {
#endif

int ax_debugEnabled();
void printDebug(char *msg);
void printError(char *msg); 


#ifdef __cplusplus
  }
#endif
#endif

