#include "mbed.h"
#include "MTSSerial.h"
#include "Wifi.h"
#include "TSISensor.h"
#include "MMA8451Q.h"
#include "MAG3110.h"
#include "USBHostCam.h"
#include "axToolkit.h"

/*********************************************/
/* In the following lines please input:      */
/* on line 17: your serial number            */
/* on line 18: your wifi SSID                */
/* on line 19: your wifi password/key        */
/* on line 20: your security type (WPA...    */
/*********************************************/

#define YOUR_SERIAL_NUM "your_serial_here_123"
#define SSID "yourWifi"
#define AP_Security "SECURITYKEYHERE"
#define AP_Key WPA2             //security type examples: NONE, WEP64, WEP128, WPA, WPA2


/*********************************************/
/*Axeda connections                          */
/*********************************************/

#define MODEL           "Freescale46"                       //using Freescale as a placeholder
#define SERVER_NAME     "216.34.120.53" //IP = 216.34.120.53/52 stage/public URL=toolbox-stage-connect.axeda.com
#define PORT_NUM        80


using namespace mts;

//Hardware Support Stuff
// Include support for on-board green and red LEDs
#define LED_ON  0
#define LED_OFF 1

DigitalOut greenLED(LED_GREEN);
DigitalOut redLED(LED_RED);
// Include support for onboard pushbuttons (value = 0 when pressed)
DigitalIn  sw1(PTC3);
DigitalIn  sw3(PTC12);
TSISensor slider;
AnalogIn  lightSense(PTE22);
#define MMA8451_I2C_ADDRESS (0x1d<<1)
MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);
MAG3110 mag(PTE25, PTE24);
//Camera support
/*
#if defined(TARGET_KL46Z)
uint8_t image_buf[1024*24];
#elif defined(TARGET_KL25Z)
uint8_t image_buf[1024*12];
#endif */


int main()
{
    TSISensor touchSensor;
    //float accels[3];
    //float resting;
    int SEVERITY;
    //int HURT_BUTTON_STATE=0;
    //int OK_BUTTON_STATE=0;
    double status=0;
    
//Some light I/O setup:    
    redLED=LED_OFF;
    greenLED=LED_OFF; 
// Turn on pull up resistors on pushbutton inputs
    sw1.mode(PullUp);
    sw3.mode(PullUp);

//Setup the Camera: 
 /*   int size=0;
    USBHostCam* cam = new USBHostCam(_320x240);
    if (!cam->connect()) {
        error("WebCam not found.\n");
        greenLED=LED_ON;
        }
    else { redLED=LED_ON; }  */
     
    //Set the network parameters
    std::string ssid = SSID;
    std::string securityKey = AP_Security;
    Wifi::SecurityType securityType = Wifi::AP_Key;

    //Wait for wifi module to boot up
    for (int i = 10; i >= 0; i = i - 2) {
        wait(2);
        printf("Waiting %d seconds...\n\r", i);
    }

    //Setup serial interface to WiFi module
    MTSSerial* serial = new MTSSerial(PTD3, PTD2, 256, 256);
    serial->baud(9600);

    //Setup Wifi class
    Wifi* wifi = Wifi::getInstance();
    printf("Init: %s\n\r", wifi->init(serial) ? "SUCCESS" : "FAILURE");
    wifi->sendBasicCommand("set comm size 1460", 500, CR);
    wifi->sendBasicCommand("set comm time 6000", 500, CR);
  //  wifi->sendBasicCommand("set comm match "+EOT, 3, CR);
    //Setup and check connection
    printf("Set Network: %s\n\r", getCodeNames(wifi->setNetwork(ssid, securityType, securityKey)).c_str());
    printf("Set DHCP: %s\n\r", getCodeNames(wifi->setDeviceIP("DHCP")).c_str());
    while (! wifi->connect()) {
        printf("Connect: Failure\r\n");
        wait(1);
    }
    printf("Connected To Wifi!");
    
//Now we setup the Axeda Service:
    ax_platform sbox;
    ax_deviceID thisDevice;
    ax_dataSet *ds[1];
 //   ax_file pic;

    ax_createPlatform(&sbox, SERVER_NAME, NULL, PORT_NUM); 
    ax_data_createModelSerialDeviceId(&thisDevice, MODEL, YOUR_SERIAL_NUM, NULL);
  //  ax_createFile(&pic, "mypic.jpg", "pic", sizeof(image_buf), (unsigned char*)&image_buf);       
   
    /*wait(0.7);
    acc.getAccAllAxis( accels );
    resting = abs(accels[0]) + abs(accels[1]) + abs(accels[2]);
    printf("Set up resting accelerometer - %.2f\r\n", resting);
    wait(0.1);*/
 
    //Ping 
    while (true) {
        ds[0]=(ax_dataSet *)malloc(sizeof(ax_dataSet));
        printf("\n\n\r ready \n\n");
        SEVERITY=0; 
        //ax_data_createSet(ds[0], 0, AX_NO_PRIORITY);     
        //HURT_BUTTON_STATE=sw1.mode(PullUp);
        //OK_BUTTON_STATE=sw3.mode(PullUp);
        sw3.mode(PullUp);
        sw1.mode(PullUp);
        while(sw3&&sw1){
            status=0;
            greenLED=LED_ON;
            wait(0.1);
            greenLED=LED_OFF;
            wait(0.1);
                if (!sw3){
                status=2;
                }
                    else{
                        status=1;
                    }
            }  
        
        //SEND button push (hurt or ok)    
        ax_data_addAnalogToSet(ds[0], "status", status);
               
        while(SEVERITY<=1){
            SEVERITY=100*touchSensor.readPercentage();
            redLED=LED_ON;
            wait(0.1);
            redLED=LED_OFF;
            wait(0.1);
            
            }
        
        SEVERITY=100*touchSensor.readPercentage();

        printf("\n\r%d\n",SEVERITY);
        //Send data about severity (left to right position on touchpad)
        ax_data_addAnalogToSet(ds[0], "severity",SEVERITY);    
        
        //Send data about orientation     

        ax_data_addAnalogToSet(ds[0], "accel_x", acc.getAccX());
        ax_data_addAnalogToSet(ds[0], "accel_y", acc.getAccY());
        ax_data_addAnalogToSet(ds[0], "accel_z", acc.getAccZ());
        
        printf("\n\r%f\n", acc.getAccX());
        printf("\n\r%f\n", acc.getAccY());
        printf("\n\r%f\n", acc.getAccZ());
    
        ax_platform_sendData(&sbox, &thisDevice, ds, 1);
        ax_data_destroySet(ds[0]);
    /*
        size = cam->readJPEG(image_buf, sizeof(image_buf));
        ax_platform_upload(&sbox, &thisDevice, &pic);
        */
    //    printf("Ping Server: %s\n\r", wifi->ping("8.8.8.8") ? "Success" : "Failed");
        wait(10);
    }
}
