#include "mbed.h"
#include <stdio.h>  
#include <string>
#include <stdlib.h>

#define BT_RX PTE1
#define BT_TX PTE0

using namespace std;

DigitalOut lRed(LED1);
DigitalOut lGrn(LED2);
DigitalOut lBlu(LED3);

AnalogIn AnInput(PTB0);
AnalogOut  AnOut(PTE30);
PwmOut pwmOut(PTE20);

Serial PC(USBTX, USBRX); // tx, rx
Serial BT(BT_TX, BT_RX); // Serial para el Bluetooth

/* Variables Globales */
// Parametros del PID sintonizado
float cKp=1.432f;
float cKi=25.95f;
float cKd=0.0f;
float cRf=1.0f;
float pwmVal = 2.0f;
float out,ai,ad,ap,med,err,err_v,uPID;
int Ts=250;

bool modo = false;
bool enter = false;

/*Indices para formatear datos del BT */

char controlChar='N';
char buffer[25]; //Buffer para almacenar los msjs del usuario
string bufferS;

void cleanBuffer(char *buffer)
{
    for(int ixI=0; ixI < 25; ixI++) {
        buffer[ixI]='\0';
    }
}

void ObtenerDatosBT(void){
    int idxIni = 0;
    int idxFin = 0;
    int idxCm[4] = {0,0,0,0};

    string strCkp;
    string strCki;
    string strCkd;
    string strCrf;

    string strPwm;

    if(BT.readable()){

        PC.printf("\nReading\n");
        BT.gets(buffer,24);
        bufferS = buffer;
        idxIni = bufferS.find_last_of('<');
        idxFin = bufferS.find_first_of('>',idxIni);

        bufferS = bufferS.substr(idxIni,((idxFin-idxIni)+1));//recortamos los datos

        idxIni = bufferS.find_last_of('<');
        idxFin = bufferS.find_first_of('>',idxIni);
        controlChar = bufferS[idxIni+1];
        PC.printf("Buffer: '%s' ControlChar:'%c'\n",bufferS.c_str(),controlChar);
        PC.printf("Leaving\n");
    }
    
    while(BT.readable()){
        char c = BT.getc();
        PC.printf("Cleaning!\n");
    }

    //Filtrado de los datos
    if(controlChar == 'C'){
        controlChar = 'N';
        idxCm[0] = bufferS.find_first_of(',');
        for (int j = 1; j < 4; j++){
            idxCm[j] = bufferS.find_first_of(',',idxCm[j-1]+1);
        }
        strCkp = bufferS.substr(idxCm[0]+1,((idxCm[1]-idxCm[0])-1));
        strCki = bufferS.substr(idxCm[1]+1,((idxCm[2]-idxCm[1])-1));
        strCkd = bufferS.substr(idxCm[2]+1,((idxCm[3]-idxCm[2])-1));
        strCrf = bufferS.substr(idxCm[3]+1,((idxFin  -idxCm[3])-1));

        PC.printf("Parametros recibidos: '%s_%s_%s_%s'\n",strCkp.c_str(),strCki.c_str(),strCkd.c_str(),strCrf.c_str());

        cKp = atof( strCkp.c_str() );
        cKi = atof( strCki.c_str() );
        cKd = atof( strCkd.c_str() );
        cRf = atof( strCrf.c_str() );
        

        PC.printf("Parametros guardados: <%c,%f,%f,%f,%f>\n",controlChar,cKp,cKi,cKd,cRf);
        modo = true;
    }

    if(controlChar == 'P'){
        controlChar = 'N';
        idxCm[0] = bufferS.find_first_of(',');

        strPwm = bufferS.substr(idxCm[0]+1,(idxFin-idxCm[0])-1);
        PC.printf("Parametros recibidos: '%s'\n",strPwm.c_str());

        pwmVal = atof( strPwm.c_str() ); 
        PC.printf("Salida guardada: <%c,%f>\n",controlChar,pwmVal);

        modo = false;
    }
}

// CICLO PRINCIPAL CONTROLADOR PID

void controlPID(){
    med = AnInput.read()*999;   //Medicion de la salida
    err = cRf*(999/3.3f) - med; //calculo del error
    ap = err*cKp*0.01f;         //Calculo accion proporcional
    ai = ai+(err*cKi*0.01f);    //Calculo accion integral
    ad = (err-err_v)*(cKd)*0.01f;//Calculo   de la accion derivativa 
    uPID=ap+ai+ad;              //Calculo de la accion de control
    if(uPID<=0){uPID=0;}        //Saturador inferior
    if(uPID>=999){uPID=999;}    //Saturador superior
    err_v = err;                //Actualizacion de error
    out=uPID*(3.3f/999);        //Conversion de voltaje a accion de control
    AnOut.write(out);           //Escritura de accion de control
    pwmOut.write(out);           //Escritura de accion de control
    BT.printf("#%f",med);
    PC.printf("PID #%f \n",med);
    //BT.printf("Ref=%fv Error=%fv Ucontrol=%fv\n\r",cRf,err/999,out);
}

void executePIDControl()
{
    PC.printf("Entre al PID\n");
    //Capturamos los parametros del controlador
    bool run=true;
    out=0;ai=0;ad=0;ap=0;med=0;err=0;err_v=0;uPID=0;

    while(run == true) {
        lRed=1;
        lBlu=1;
        lGrn=0;
        controlPID();
        wait_ms(Ts);
        //ObtenerDatosBT();
        if(BT.readable()>0
            /* controlChar =='P' || controlChar == 'C'*/) {
            run = false;
        }
    }
}

int main()
{
    BT.baud(9600);
    AnOut.write(0.0f);
    pwmOut.write(0.0f);
    lRed = 1;
    lBlu = 1;
    for(int indexI = 0; indexI<3; indexI++) {
        /* Parpadeo de LEDS para indicar el inicio*/
        lGrn = 0;
        wait(0.25);
        lGrn = 1;
        wait(0.25);
    }
    PC.printf("\nProgram Start!\n");

    /*Led en naranja para indicar que esta listo para recibir parametros*/
    lRed = 0;
    lGrn = 0;

    while(1) {
        cleanBuffer(buffer);    
        ObtenerDatosBT();
                
        if (modo == true){
            executePIDControl();    
        }
        
        if( modo == false){
            lBlu = 0;
            lRed = 1;
            lGrn = 1;
            pwmOut.write(pwmVal);
            AnOut.write(pwmVal);  

            med = AnInput.read()*1000;   //Medicion de la salida
            BT.printf("#%f",med);
            //PC.printf("PWM #%f \n",med);
        } 
       wait_ms(Ts);                 
    }
}

