#include "mbed.h"
#include "USBKeyboard.h"

USBKeyboard keyboard; // Clavier branchement : bleu D+ blanc D-

//Fonction
void BpRead(); // Lecture des 3 boutons pour lancer le jeu
void InitRelais(); // Met les Pins des relais à l'état bas  
void Jouer(); // Envoi de la touche 1 au PC
void Play(); // Envoi de la touche 2 au PC
void Arret(); // Envoi de la touche 3 au PC
void PinRead(); // Lecture des pins du Joystick et du volant
void WriteAV(); // Envoi de la touche Flèche Avant au PC + activation du relai 1
void WriteAR(); // Envoi de la touche Flèche Arrière au PC + activation du relai 2
void WriteJD(); // Envoi de la touche X au PC + activation du relai 3
void WriteJG(); // Envoi de la touche W au PC + activation du relai 4
void WriteVG(); // Envoi de la touche Flèche Gauche au PC + activation du relai 5
void WriteVD(); // Envoi de l atouche Flèche Droite au PC + activation du relai 6

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//Variables et Constantes

 const unsigned int t = 1; // Temps en s
 
 //Val dépend du banchement des boutons 
 const unsigned int val = 1;
 
 unsigned int x = 0;
  
 //Relais
 DigitalOut R1(p5);//relai 1
 DigitalOut R2(p6);//relai 2
 DigitalOut R3(p7);//relai 3
 DigitalOut R4(p8);//relai 4
 DigitalOut R5(p9);//relai 5
 DigitalOut R6(p10);//relai 6
 
//Boutons contact normalement fermé
//bouton "Démarrer Jeu" envoyé 1
DigitalIn Jeu(p21); //vert bleu
unsigned int jeu;
//bouton "Start Game" envoyé 2
DigitalIn Game(p22); //jaune bleu
unsigned int game;
//bouton "Stop" envoyé 3
DigitalIn Stop(p23); //rouge bleu
unsigned int stop;

//Joystick contact normalement ouvert
//bouton "Joystick Avant" envoyé flèche haut
DigitalIn Av(p29); //vert
unsigned int av;
//bouton "Joystick Arrière" envoyé flèche bas
DigitalIn Ar(p25);//rouge
unsigned int ar;
//bouton "Joystick Droit" envoyé W
DigitalIn Jdroit(p26); //jaune
unsigned int jdroit;
//bouton "Joystick Gauche" envoyé X
DigitalIn Jgauche(p27); //orange
unsigned int jgauche;

//Volant contact normalement ouvert
DigitalIn VD(p24); //bleu
unsigned int vd;
DigitalIn VG(p28); //gris
unsigned int vg;
