/* SCIboard(TM) L3G4200DTR.cpp
Copyright (c) 2013 K. Andres

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#include "SCIboard_L3G4200DTR.h"

SCIboard_L3G4200DTR::SCIboard_L3G4200DTR(SCIboard_I2C *ptr_I2C, int iDR, int iBW, int iFS) {
   float FS[] = {250, 500, 2000};
   unsigned char data[2];

   pI2C = ptr_I2C;

   data[0] = GYRREG_CTRL_REG1;
   data[1] = 0x0F;                                  // 0xXF = Normal mode with Zen, Yen, Xen
   data[1] |= iDR << 6;
   data[1] |= iBW << 4;
   pI2C->writeRegs(L3G4200DTR_I2C_ADDR, data, 2);

   data[0] = GYRREG_CTRL_REG3;
   data[1] = 0x08;                                  // Data Ready on DRDY/INT2
   pI2C->writeRegs(L3G4200DTR_I2C_ADDR, data, 2);

   gyrSF = 32768.0 / FS[iFS];
   
   data[0] = GYRREG_CTRL_REG4;
   data[1] = iFS << 4;
   data[1] |= 0x80;                                  // Block Data Update
   pI2C->writeRegs(L3G4200DTR_I2C_ADDR, data, 2);
}

unsigned char SCIboard_L3G4200DTR::getDeviceID(void) {
    unsigned char data;
    pI2C->readRegs(L3G4200DTR_I2C_ADDR, GYRREG_WHO_AM_I, &data, 1);
    return data;
}

unsigned char SCIboard_L3G4200DTR::getStatus(void) {
    unsigned char data;
    pI2C->readRegs(L3G4200DTR_I2C_ADDR, GYRREG_STATUS, &data, 1);
    return data;
}

void SCIboard_L3G4200DTR::getData(float *rtn) {
    char data[6];

    pI2C->readRegs(L3G4200DTR_I2C_ADDR, GYRREG_OUT_X_L, (unsigned char*)data, 6);

    rtn[0] = float(short(data[1] << 8 | data[0])) / gyrSF;
    rtn[1] = float(short(data[3] << 8 | data[2])) / gyrSF;
    rtn[2] = float(short(data[5] << 8 | data[4])) / gyrSF;
}

void SCIboard_L3G4200DTR::getTemp(float *rtn) {
    unsigned char data;
    pI2C->readRegs(L3G4200DTR_I2C_ADDR, GYRREG_OUT_TEMP, &data, 1);
    *rtn = (char)data;
}

