/* SCIboard(TM) MPL3115A2.h
Copyright (c) 2013 K. Andres

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#ifndef __SCIboard_MPL3115A2_H
#define __SCIboard_MPL3115A2_H

#include "mbed.h"
#include "SCIboard_I2C.h"

// Freescale Semiconductor www.freescale.com - I2C Precision Altimeter
// Data sheet Rev 2.2 07/2012
#define MPL3115A2_I2C_ADDR (0x60<<1)

// Altimeter registers
#define ALTREG_STATUS              0x00
#define ALTREG_OUT_P_MSB           0x01
#define ALTREG_OUT_T_MSB           0x04
#define ALTREG_DR_STATUS           0x06
#define ALTREG_WHO_AM_I            0x0C
#define ALTREG_SYSMOD              0x11
#define ALTREG_PT_DATA_CFG         0x13
#define ALTREG_CTRL_REG1           0x26
#define ALTREG_CTRL_REG2           0x26
#define ALTREG_CTRL_REG3           0x28
#define ALTREG_CTRL_REG4           0x29
#define ALTREG_CTRL_REG5           0x2A

// Altimeter oversampling value and minimum time between sample - Ratio x 4 ms + 2 ms
                        // Min time between samples
#define OS1      0      // 6 ms
#define OS2      1      // 10 ms
#define OS4      2      // 18 ms
#define OS8      3      // 34 ms
#define OS16     4      // 66 ms
#define OS32     5      // 130 ms
#define OS64     6      // 258 ms
#define OS128    7      // 512 ms

// Altimter modes
#define ALT_MODE    1
#define BAR_MODE    0

class SCIboard_MPL3115A2
{
public:
    SCIboard_MPL3115A2(SCIboard_I2C *ptr_I2C);
    unsigned char getDeviceID(void);
    void setMode(unsigned char mode, unsigned char overSampling);
    void OST(void);
    bool bDataAvailable(void);
    unsigned char getDrStatus(void);
    unsigned char getSysmod(void);
    void getData(float *rtn);
    
private:
    SCIboard_I2C *pI2C;
    unsigned char recallMode;
};

#endif
