/* SCIboard(TM) MOSFET.cpp
Copyright (c) 2013 K. Andres

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#include "SCIboard_MOSFET.h"

#define ADC_SCALE_FACTOR    14.2376

// LEDs
extern DigitalOut led1;
extern DigitalOut led2;
extern DigitalOut led3;
extern DigitalOut led4;

// Buzzer
extern DigitalOut alert;

// FET controls
extern DigitalOut fet_out1;
extern DigitalOut fet_out2;
extern DigitalOut fet_out3;
extern DigitalOut fet_out4;

// ADC inputs
extern AnalogIn batt_mon;
extern AnalogIn fet_mon1;
extern AnalogIn fet_mon2;
extern AnalogIn fet_mon3;
extern AnalogIn fet_mon4;

// Timers
Timeout timeoutFet1, timeoutFet2, timeoutFet3, timeoutFet4;
 

SCIboard_Mosfet::SCIboard_Mosfet(void) {
}


// Timeout subroutines
void fet1_Off() {
    led1 = 0;
    fet_out1 = 0;
    timeoutFet1.detach();
}

void fet2_Off() {
    led2 = 0;
    fet_out2 = 0;
    timeoutFet1.detach();
}

void fet3_Off() {
    led3 = 0;
    fet_out3 = 0;
    timeoutFet1.detach();
}

void fet4_Off() {
    led4 = 0;
    fet_out4 = 0;
    timeoutFet1.detach();
}


// Command MOSFET on for duration (seconds)
void SCIboard_Mosfet::setFet(int iFetNum, float fDuration) {
    switch(iFetNum) {
        case 1:
            led1 = 1;
            fet_out1 = 1;
            timeoutFet1.attach(&fet1_Off, fDuration);
            break;
            
        case 2:
            led2 = 1;
            fet_out2 = 1;
            timeoutFet2.attach(&fet2_Off, fDuration);
            break;
            
        case 3:
            led3 = 1;
            fet_out3 = 1;
            timeoutFet1.attach(&fet3_Off, fDuration);
            break;
            
        case 4:
            led4 = 1;
            fet_out4 = 1;
            timeoutFet1.attach(&fet4_Off, fDuration);
            break;
            
        default:        
            break;
    }
}


// CAUTION: Small current flows through sense resistor (30K ohm)
//   whenever arm switch is on. Used to determine continuity of circuit
// Does not include reverse polarity protection diode voltage drop
float SCIboard_Mosfet::getFetVoltage(int iFetNum) {
    float f;

    switch(iFetNum) {
        case 1:
            f = fet_mon1;
            break;
            
        case 2:
            f = fet_mon2;
            break;
            
        case 3:
            f = fet_mon3;
            break;
            
        case 4:
            f = fet_mon4;
            break;

        default:
            f=0;
            break;            
    }
    return(f * ADC_SCALE_FACTOR);
}

// Does not include reverse polarity protection diode voltage drop
float SCIboard_Mosfet::getBattVoltage(void) {
    return(batt_mon * ADC_SCALE_FACTOR);
}
