/* SCIboard(TM) LSM303DLHC.h
Copyright (c) 2013 K. Andres

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#ifndef SCIboard_LSM303DLHC_H
#define SCIboard_LSM303DLHC_H

#include "mbed.h"
#include "SCIboard_I2C.h"

// STMicroelectronics www.st.com - Ultra compact high performance
// e-compass, 3D accelerometer, and 3D magnetometer module
// Data sheet - Preliminary data - Rev 1
#define ACC_I2C_ADDR (0x19<<1)
#define MAG_I2C_ADDR (0x1E<<1)

// Acc Registers
#define ACCREG_CTRL_REG1        0x20
#define ACCREG_CTRL_REG2        0x21
#define ACCREG_CTRL_REG3        0x22
#define ACCREG_CTRL_REG4        0x23
#define ACCREG_CTRL_REG5        0x24
#define ACCREG_CTRL_REG6        0x25
#define ACCREG_REFERENCE        0x26
#define ACCREG_STATUS           0x27
#define ACCREG_OUT_X_L          0x28
#define ACCREG_OUT_Y_L          0x2A
#define ACCREG_OUT_Z_L          0x2C

#define ACCREG_INT1_CFG         0x30
#define ACCREG_INT1_SOURCE      0x31
#define ACCREG_INT1_THS         0x32
#define ACCREG_INT1_DURATION    0x33

#define ACCREG_INT2_CFG         0x34
#define ACCREG_INT2_SOURCE      0x35
#define ACCREG_INT2_THS         0x36
#define ACCREG_INT2_DURATION    0x37

// Mag Resisters
#define MAGREG_CRA_REG          0x00
#define MAGREG_CRB_REG          0x01
#define MAGREG_MR_REG           0X02
#define MAGREG_OUT_X_H          0x03
#define MAGREG_OUT_Z_H          0x05    // Note Z out of order
#define MAGREG_OUT_Y_H          0x07
#define MAGREG_SR_REG           0x09

#define MAGREG_IRA_REG          0x0A

#define MAGREG_TEMP_OUT_H       0x31


// Status Register
#define STATUS_REG_ZYXDA        0x08

// ACCREG_CTRL_REG1 Output Data Rate (ODR)
#define ACC_1HZ                 1
#define ACC_10HZ                2
#define ACC_25HZ                3
#define ACC_50HZ                4
#define ACC_100HZ               5
#define ACC_200HZ               6
#define ACC_400HZ               7
#define ACC_1620HZ              8       // Low power mode
#define ACC_5376HZ              9       // Low power mode / Normal 1344Hz

// ACCREG_CTRL_REG4 Full-scale selection +/-g
#define ACC_2G                  0
#define ACC_4G                  1
#define ACC_8G                  2
#define ACC_16G                 3

// MAGREG_CRA_REG
#define MAG_TEMP_EN             0x80
#define MAG_0p75HZ              0
#define MAG_1p5HZ               1
#define MAG_3p0HZ               2
#define MAG_7p5HZ               3
#define MAG_15HZ                4       // Default
#define MAG_30HZ                5
#define MAG_75HZ                6
#define MAG_220HZ               7

// MAGREG_CRB_REG Gain setting [Gauss]
#define MAG_1p3G                1
#define MAG_1p9G                2
#define MAG_2p5G                3
#define MAG_4p0G                4
#define MAG_4p7G                5
#define MAG_5p6G                6
#define MAG_8p1G                7

// MAGREG_MR_REG Mode select bits
#define MAG_Continuous_Conv     0
#define MAG_Single_Conv         1
#define MAG_Sleep_Mode          2

// MAGREG_SR_REG 
#define MAG_DRDY                1
#define MAG_LOCK                2


class SCIboard_LSM303DLHC
{
public:
    SCIboard_LSM303DLHC(SCIboard_I2C *ptr_I2C);
    void getDeviceID(unsigned char *id);

    void setAccMode(unsigned char AccFs, unsigned char AccRate);
    unsigned char getAccStatus(void);
    bool bAccDataAvailable(void);
    void getAccData(float *fData);
    unsigned char getInt1Src(void);
    void writeCtrlReg(unsigned char reg, unsigned char value);

    void setMagMode(unsigned char MagFs, unsigned char MagRate);
    unsigned char getMagStatus(void);
    bool bMagDataAvailable(void);
    void getMagData(float *fData);
    void getMagData(char *cData);
    float getTemp(void);
    void getTemp(char *cData);
  
private:
    SCIboard_I2C *pI2C;
    float accSF;
    float accRate;
    float magSF[3];
    float magRate;
};

#endif
