/* SCIboard(TM) MPL3115A2.cpp
Copyright (c) 2013 K. Andres

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#include "SCIboard_MPL3115A2.h"

SCIboard_MPL3115A2::SCIboard_MPL3115A2(SCIboard_I2C *ptr_I2C) {
   pI2C = ptr_I2C;    
}

unsigned char SCIboard_MPL3115A2::getDeviceID(void) {
    unsigned char data;
    pI2C->readRegs(MPL3115A2_I2C_ADDR, ALTREG_WHO_AM_I, &data, 1);
    return data;
}

void SCIboard_MPL3115A2::setMode(unsigned char mode, unsigned char overSampling) {
    unsigned char data[2] = {ALTREG_CTRL_REG1, 0};
    
    wait(.01);
    // Standby
    pI2C->readRegs(MPL3115A2_I2C_ADDR, data[0], &data[1], 1);
    data[1] &= 0xFE;
    pI2C->writeRegs(MPL3115A2_I2C_ADDR, data, 2);
    
    // Reset
    wait(.01);
    data[1] |= 0x04;
    pI2C->writeRegs(MPL3115A2_I2C_ADDR, data, 2);
    
    // Standby
    wait(.01);
    pI2C->readRegs(MPL3115A2_I2C_ADDR, data[0], &data[1], 1);
    data[1] &= 0xFA;
    pI2C->writeRegs(MPL3115A2_I2C_ADDR, data, 2);
    
    // Mode and overSampling
    wait(.01);
    data[1] &= 0xc7;
    data[1] |= overSampling << 3;
    recallMode = mode;
    if(mode)
        data[1] |= 0x80;
    else
        data[1] &= 0x7F;
    pI2C->writeRegs(MPL3115A2_I2C_ADDR, data, 2);    

    //    
    data[0] = ALTREG_PT_DATA_CFG;
    data[1] = 0x07;    
    pI2C->writeRegs(MPL3115A2_I2C_ADDR, data, 2);    
    
    // 
    data[0] = ALTREG_CTRL_REG4;
    data[1] = 0x80;                                 // INT_EN_DRDY
    pI2C->writeRegs(MPL3115A2_I2C_ADDR, data, 2);    
    
    // 
    data[0] = ALTREG_CTRL_REG5;
    data[1] = 0x80;                                 // INT_CFG_DRDY
    pI2C->writeRegs(MPL3115A2_I2C_ADDR, data, 2);    
}
 

void SCIboard_MPL3115A2::OST(void) {
    unsigned char data[2]={ ALTREG_CTRL_REG1, 0};
    
    pI2C->readRegs(MPL3115A2_I2C_ADDR, ALTREG_CTRL_REG1, &data[1], 1);
    data[1] |= 0x02;    // Command OST
    data[1] &= 0xfe;    // Force STANDBY
    pI2C->writeRegs(MPL3115A2_I2C_ADDR, data, 2);
}

bool SCIboard_MPL3115A2::bDataAvailable(void) {
    unsigned char data;

    pI2C->readRegs(MPL3115A2_I2C_ADDR, ALTREG_STATUS, &data, 1);
    if(data & 0x08)
        return true;

    return false;
}

unsigned char SCIboard_MPL3115A2::getDrStatus(void) {
    unsigned char data;

    pI2C->readRegs(MPL3115A2_I2C_ADDR, ALTREG_STATUS, &data, 1);
    return data;
}

unsigned char SCIboard_MPL3115A2::getSysmod(void) {
    unsigned char data;

    pI2C->readRegs(MPL3115A2_I2C_ADDR, ALTREG_SYSMOD, &data, 1);
    return data;
}

void SCIboard_MPL3115A2::getData(float *rtn) {
    unsigned char data[5];
    unsigned short i;
    float f;
       
    pI2C->readRegs(MPL3115A2_I2C_ADDR, ALTREG_OUT_P_MSB, data, 5);
    
    if(recallMode)
    {   // Altimeter
        i = (data[0]<<8) | data[1];
        if(data[0] > 0x7F)
        {
            i = ~i + 1;
            rtn[0] = (float)i * -1.0;
        }    
        else
        {
            rtn[0] = (float)i * 1.0;
        }
    }
    else
    {   // Pressure
        i = (data[0]<<10) | (data[1]<<2) | (data[2]>>6);
        rtn[0] = (float)i * 1.0;
        if(data[2] & 0x20)
            rtn[0] += 0.5;
        if(data[2] & 0x10)
            rtn[0] += 0.025;
    }
    
    // Convert temperature
    i = data[3];
    if(data[3] > 0x7F)
    {
        i = ~i + 1;
        f = (float)i * -1.0f;
    }    
    else
    {
        f = (float)i * 1.0f;
    }
    rtn[1] = f + ((float)(data[4]>>4) * 0.0625f);
}
