/* SCIboard(TM) L3G4200DTR.h
Copyright (c) 2013 K. Andres

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#ifndef __SCIboard_L3G4200DTR_H
#define __SCIboard_L3G4200DTR_H

#include "mbed.h"
#include "SCIboard_I2C.h"

// STMicroelectronics www.st.com - Ultra-stable three-axis digital output gyroscope
// Preliminary data 12/2010
#define L3G4200DTR_I2C_ADDR (0x69<<1)

// Gyro registers
#define GYRREG_WHO_AM_I             0x0F
#define GYRREG_CTRL_REG1            0x20
#define GYRREG_CTRL_REG2            0x21
#define GYRREG_CTRL_REG3            0x22
#define GYRREG_CTRL_REG4            0x23
#define GYRREG_CTRL_REG5            0x24
#define GYRREG_REFERENCE            0x25
#define GYRREG_OUT_TEMP             0x26
#define GYRREG_STATUS               0x27
#define GYRREG_OUT_X_L              0x28

// Output Data Rate (DR)
#define GYR_DR_100HZ                0
#define GYR_DR_200HZ                1
#define GYR_DR_400HZ                2
#define GYR_DR_800HZ                3

// Bandwidth
#define GYR_BW_0                    0
#define GYR_BW_1                    1
#define GYR_BW_2                    2
#define GYR_BW_3                    3

// Full Scale
#define GYR_FS_250DPS               0
#define GYR_FS_500DPS               1
#define GYR_FS_2000DPS              2

// STATUS_REG
#define STATUS_REG_ZYXDA            0x08

class SCIboard_L3G4200DTR
{
public:
    SCIboard_L3G4200DTR(SCIboard_I2C *ptr_I2C, int iDR, int iBW, int iFS);
    unsigned char getDeviceID(void);
    unsigned char getStatus(void);
    void getData(float *rtn);
    void getTemp(float *rtn);
    
private:
    SCIboard_I2C *pI2C;
    float gyrSF;
};

#endif
