/* SCIboard(TM) DataLogger.cpp
Copyright (c) 2013 K. Andres

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#include "SCIboard_DataLogger.h"

LocalFileSystem local("local");               // Create the local filesystem under the name "local"

char filenm[40] = "/local/OUT.CSV";

//#define LOGTEST
#ifdef LOGTEST
Timer logTimer;

int main()
{
    logTimer.start();  // Start timer
    led1=1;
    log_open();
    for(n=0; n<1000; n++) {
        sprintf(str,"%d %d \r\n", n, logTimer.read_ms());
//        sprintf(str,"%d\r\n", n);
        log_write(str);
        wait(0.01);
        if(!(n%50)) {
            led1=!led1;
        }
    }
    log_close();
    logTimer.stop();
    led2=1;
}
#endif


//---------------------------------------------------------------------
FILE *fp=NULL;

void log_open(void)
{
    if(fp==NULL) {
        fp = fopen(filenm, "w");  // Open file for appending
    }
}


void log_close(void)
{
    if(fp!=NULL) {
        fclose(fp);
        fp=NULL;
    }
}


void log_write(char *str)
{
    if(fp!=NULL) {
        fprintf(fp, str);
    }
}


bool fileExists(char *filename) {
    bool result = false;
    DIR *d;
    struct dirent *ptr;
    d = opendir("/local");
 
    if(d != NULL ) {
        while (!result && (ptr = readdir(d)) != NULL) {
            if(strcmp(ptr->d_name, filename) == 0)
                result = true;
        }
    }
    closedir(d);
    return(result);
}


void nextFilename(void) {
    bool result=true;
    int filenum=1;
    char tempStr[80]="/local/";;
    
    while(result==true) {
        sprintf(filenm, "OUT%02d.CSV", filenum);
        if(fileExists(filenm)) {
            filenum++;
        }
        else {
            result = false;
        }
    }
    
    strcat(tempStr, filenm);
    strcpy(filenm, tempStr);
}
