/* SCIboard(TM) ConfigFile.cpp
Copyright (c) 2013 K. Andres

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#include "SCIboard_ConfigFile.h"

ConfigFile::ConfigFile(char *filename) {
//    printf("ConfigFile(%s)\n\r", filename);
    fp = fopen(filename,"r");
    if(fp==NULL)
        error("ConfigFile failure to open\r\n");
}

ConfigFile::~ConfigFile() {
    closeFile();
}


void ConfigFile::closeFile(void) {
//    printf("ConfigFile::Close()\n\r");
    if(fp!=NULL)
        fclose(fp);
    fp=NULL;
}

bool ConfigFile::getValue(char *key, bool *value) {
    char str[83];
    *value=0;
    if(getValue(key, str)) {
        *value = atoi(str);
        return true;
    }
    return false;
}


bool ConfigFile::getValue(char *key, int *value) {
    char str[83];
    *value=0;
    if(getValue(key, str)) {
        *value = atoi(str);
        return true;
    }
    return false;
}


bool ConfigFile::getValue(char *key, float *value) {
    char str[83];
    *value=0;
    if(getValue(key, str)) {
        *value = atof(str);
        return true;
    }
    return false;
}


bool ConfigFile::getValue(char *key, char *value) {
    char *ptr;
    char str[83];

    if(fp == NULL)
    {
        strcpy(value, "");
        return false;
    }

    fseek(fp, 0L, SEEK_SET);
    
    while(fgets(str, 80, fp) != NULL) {
        ptr = strtok(str,":");
        if(!strcmp(str,key)) {
            ptr = strtok(NULL,":");
            if(ptr!=NULL) {
                strcpy(value,ptr);
                return true;
            }
        }
    }

    return false;
}

