#define APP_VERSION     0.6f
#define MQTT_VERSION    3
#define BROKER_NAME     "broker.hivemq.com"
#define BROKER_PORT     1883

#include "debounce_button.h"
#include "EthernetInterface.h"
#include "MQTTNetwork.h"
#include "MQTTmbed.h"
#include "MQTTClient.h"

char* topic = "test/embedded\0";

void sendMessage(MQTT::Client<MQTTNetwork, Countdown>* client, char* topic, char* payload, int qos, bool retained, bool duplicate);

/**
    TODO
    ----
    -   Check if the button has been pressed. If so, print the amount of clicks to a serial terminal.
    -   Make an MQTT-service which:
        -   starts up a network using EthernetInterface. Make sure the development board requests its address via DHCP.
        -   makes a client and connects it to the broker using a client ID and credentials (username & password).
        -   sends messages at the same topic as the smartphone app from PGO 2. Feel free to choose which Quality of Service
            you are going to use. Make a separate function which handles the sending procedure. Therefore, this function
            can be called each time we want to send a certain message.
    -   When the button is pressed once, we send an upvote. When pressed twice, a downvote is sent. By pressing 4 times,
        the program disconnects from the broker and terminates.
        
    Extra
    -----
    -   Subscribe to the topic on which the song data is published. Display this received message on the serial terminal.
    -   Test this controller in the complete system of PGO 2. Use these controllers instead of the smartphones.
    
    Tips & tricks
    -------------
    -   To generate an interrupt on the press of a button, use:
            InterruptIn button(USER_BUTTON);
            ...
            button.fall(callback(someFunction));
    -   Before implementing MQTT, test the multiclick feature first.
    -   Have a look at the MQTT-library for Mbed and the HelloMQTT-example.
    -   To have a uniform message sending procedure, use the following function usage:
            sendMessage(&client, topic, buf, qos, retained, duplicate)
*/

int main(int argc, char* argv[])
{
    printf("STARTED!\n");
    InterruptIn button(USER_BUTTON);
    button.fall(callback(&button1_onpressed_cb));
    init_debouncer();
    
    printf("Trying to connect to ethernet network\n");
    EthernetInterface network;
    int error = network.connect();
    if(error != 0)
    {
        printf("ERROR: ethernet.connect() = %d\n", error);
    }
    const char* ip_add = network.get_ip_address();
    
    printf("Success!\n");
    printf("Trying to connect to MQTT network\n");
    
    MQTTNetwork mqttNetwork(&network);
    
    MQTT::Client<MQTTNetwork, Countdown> client(mqttNetwork);
    
    error = mqttNetwork.connect(BROKER_NAME, BROKER_PORT);
    if(error != 0)
    {
        printf("ERROR: mqtt.connect() = %d\n", error);
    }
    printf("Success\n");
    
    MQTTPacket_connectData data = MQTTPacket_connectData_initializer;
    data.MQTTVersion = MQTT_VERSION;
    data.clientID.cstring = "test";
    data.username.cstring = "username";
    data.password.cstring = "password";
    
    error = client.connect(data);
    if(error != 0)
    {
        printf("ERROR: client.connect() = %d\n", error);
    }
    
    printf("INITIALIZED\n");
    
    bool connected = true;
    
    while(connected)
    {
        if(button1_pressed)
        {
            char* buf = "";
            printf("Clicks: %d\n", multiclick_state);
            button1_pressed = false;
            
            switch(multiclick_state)
            {
                case 1:
                    buf = "upvote\n";
                    sendMessage(&client, topic, buf, 0, false, false);
                    printf("upvote\n");
                    break;
                case 2:
                    buf = "downvote\n";
                    sendMessage(&client, topic, buf, 0, false, false);
                    printf("downvote\n");
                    break;
                case 4:
                    mqttNetwork.disconnect();
                    connected = false;
            }
        }
    }
    printf("DISCONNECTED!\n");
    return 0;
}

void sendMessage(MQTT::Client<MQTTNetwork, Countdown>* client, char* top, char* payload, int qos, bool retained, bool duplicate)
{
    MQTT::Message message;
    
    switch(qos)
    {
        case 0:
            message.qos = MQTT::QOS0;
            break;
        case 1:
            message.qos = MQTT::QOS1;
            break;
        case 2:
            message.qos = MQTT::QOS2;
            break;
        default:
            message.qos = MQTT::QOS0;
    }
    message.retained = retained;
    message.dup = duplicate;
    message.payload = (void*)payload;
    message.payloadlen = strlen(payload) + 1;
    
    int error = client->publish(top, message);
    if(error != 0)
    {
        printf("ERROR: client.publish() = %d\n", error);
    }
}
