/* Martin Cottrell v0.1                                            */
/* Thanks for all the examples this is based on                    */
/* This is an initial proof of concept using PCA9685 with microbit */
/* Needs many refinements and I'll also looking at PWM 9110s next  */
/* Enjoy!                                                          */

#include "MicroBit.h"
#include "MicroBitPCA9685.h"
MicroBit uBit;

int setServoPulse(MicroBitPCA9685& uPCA9685, uint8_t n, float pulse) {
    float pulselength = 10000;   // 10,000 units per seconds
    pulse = 4094 * pulse / pulselength;
    return uPCA9685.setPWM(n, 0, pulse);
}

int setAllServoPulse(MicroBitPCA9685& uPCA9685, float pulse) {
    float pulselength = 10000;   // 10,000 units per seconds
    pulse = 4094 * pulse / pulselength;
    return uPCA9685.setAllPWM(0, pulse);
}
 
void initServoDriver(MicroBitPCA9685& uPCA9685) {
    uPCA9685.begin();
    uPCA9685.setPrescale(64);    //This value is decided for 10ms interval.
    uPCA9685.frequencyI2C(400000); //400kHz
 }

int main()
{
     // Initialise the micro:bit runtime.
    uBit.init();
    MicroBitPCA9685 uPCA9685(uBit.i2c, 0x80);
    //0x80 out the box PCA9685 address

    initServoDriver(uPCA9685);
    while(true){  
        uBit.display.scroll("All");
        setAllServoPulse(uPCA9685, 2300);
        wait(0.5);
        setAllServoPulse(uPCA9685, 1350);
        wait(0.5);
        
        for (int mov = 550; mov < 2300; mov++){
            setAllServoPulse(uPCA9685, mov);
            wait(0.001); 
        } 
            
        for (int motor = 0; motor < 7; motor++){
            //I had 7 servos!
            char buf[2];
            sprintf(buf, "%d", motor);
            uBit.display.scroll(buf, 50);
    
            wait(0.2);
            setServoPulse(uPCA9685, motor, 2300);
   
            wait(0.4);//delay necessary to perform the action
            setServoPulse(uPCA9685, motor, 1350);
            wait(0.4);
            
            for (int mov = 550; mov < 2300; mov++){
                setServoPulse(uPCA9685, motor, mov);
                wait(0.001); 
            } 
        } 
    
   }
}