/* ###########################################################################
**    Archivo        : main.c
**    Proyecto       : STM32-103C8_Adivina
**    Procesador     : STM32F103C8
**    Herramienta    : Mbed
**    Version        : Driver 01.01
**    Compilador     : GNU C Compiler
**    Fecha/Hora     : 14-07-2015, 11:48, # CodeGen: 0
**    Descripción    :
**         Este proyecto muestra la configuración y uso de la Terminal Serial
**         This module contains user's application code.
**   Componentes     : Timer, etc .
**   Configuraciones : Se puede seleccionar entre diferentes velocodades de 
**                     transmisión
**   Autores         :
**         ATEAM Development Group:
**          - Arturo Rios Ramos
**
**   Versión        : Beta
**   Revisión       : A
**   Release        : 0
**   Bugs & Fixes   :
**   Date           : 13/09/2019
**                    Formula General
**                    27/09/2010 
**                    
**
** ###########################################################################*/
/*
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:  Includes
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
*/

#include "stm32f103c8t6.h"
#include "mbed.h"
#include "Serial.h"
#include "stdio.h"
#include "math.h"
/*
:...............................................................................
:  Definiciones
:...............................................................................
*/
#define on              0               // Estado para boton presionado
#define off             1               // Estado para boton sin presionar
#define hold            2               // Estado para boton mantenido
#define release         3               // Estado para boton liberado
#define FALSE           0               // Estado FALSO
#define TRUE            1               // Estado VERDADERO
/*
+-------------------------------------------------------------------------------
|  Configuración de Puertos 
+-------------------------------------------------------------------------------
*/
DigitalOut verde (LED1);    // PC_13    (Green_Led)
DigitalOut rojo  (PB_1);    // NC       (Red_Led)

// *****    Host PC Terminal Communication channels
Serial      terminal (PA_2, PA_3);          // Inicializa la comunicación serial a la PC (Tx,Rx)
//Serial      terminal(USBTX, USBRX,115200);// Tx, Rx  Baud Rate - Terminal Serial por USB @ 115,200 Bauds

/*
+-------------------------------------------------------------------------------
|  Variables Globales de Usuario 
+-------------------------------------------------------------------------------
*/
//uint32_t Baud_Rate = 9600;                // Velocidad de Transmisión (Bauds)
/*
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
|  Definición de Funciones Prototipo y Rutinas de los Vectores de Interrupción
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*/
void Setup(void);  
/* END definitions */ 

/*
#===============================================================================
|
|               P R O G R A M A     P R I N C I P A L
|
#=============================================================================== 
*/
int main()          
{                   // Inicialización de variables, puertos e interrupciones
confSysClock();     // Configure system clock (72MHz HSE clock, 48MHz USB clock)
Setup();            // Inicialización del sistema
    float _a,_b,_c,x1,x2; //Declaracion de variables
 
    terminal.printf("Valor de A: ");
    terminal.scanf("%f",&_a);
    terminal.printf("Valor de B: ");
    terminal.scanf("%f",&_b);
    terminal.printf("Valor de C: ");
    terminal.scanf("%f",&_c);
 
  
    if(((_b*_b)-(4*_a*_c))>0){
  
        x1=(float)(((-1)*_b)+(sqrt((_b*_b)-(4*_a*_c))))/2;
        x2=(float)(((-1)*_b)-(sqrt((_b*_b)-(4*_a*_c))))/2;
        printf("X1 = %.2fn",x1);
        printf("X2 = %.2fn",x2);
 
    }
    else{
        printf("ERROR: La ecuacion no tiene resultado.");
    }
}

/* END main */

/*
................................................................................
:  Rutinas de los Vectores de Interrupción
................................................................................
*/
 
/* END Events */ 
/*
________________________________________________________________________________
|
|  Funciones Prototipo
|_______________________________________________________________________________
*/
                // Las Funciones Prototipo van aquí !
void Setup()
{
//  terminal.baud(Baud_Rate);         // Se configura la velocidad de transmisión e inicia la comunicación serial.    
  terminal.baud(115200);         // Se configura la velocidad de transmisión e inicia la comunicación serial.  
  terminal.printf(" System is Wake Up!.\n\r");
}              

/* END routines */   
 
/* END program */                

/* END documentation */ 
/*
+--------------------------------------------------------------------------------
|                               EJERCICIO
|
| 1.-   Este programa tambien acepta letras o caracteres?
| 2.-   Modificar este programa para: 
|       a) Que solo acepte números
|       b) Agregar un contador de Número de Intentos 
|       
+--------------------------------------------------------------------------------
|
|                               EXAMEN
|
| 1.-   Modificar el programa para que despliegue el número de intentos para 
|       adivinar el número secreto.
| 2.-   Modificar el programa para haga eco con la respuesta que le introducimos.
|
| 3.-   Modificar el programa para que el número secreto sea generado aleatoriamente.
|       a) Generar un Número Pseudo Aleatorio Mediante el Ticker
|       b) Utilizando la función RANDOMIZE
| Suerte!
+--------------------------------------------------------------------------------
|
|                     T H E     A N T U L I U S   T E A M
|  Research, Development, Systems Equipment, Support & Spare Parts    I n c.
|                (C) Copyright 1989-2014, All rigths Reserved
|
| This program is licensed under rules of
| THE BEANERS TECHNOLOGIES PROYECT
+-------------------------------------------------------------------------------
*/
/* END Mbed */ 