/* @author: Arthur Semjonov 
 * @author: Jonathan Pucceti
 */ 
#include "mbed.h"
Serial pc(USBTX, USBRX);
InterruptIn interrupt(p14);
DigitalOut led(LED1);
Timer t;
Ticker ticker;

char arrayWords[2048]; // array of characters assuming. Maximum wpm is near 250
int nWords = 0;        // number of words
int x = 0;             // track number of characters entered into an array


void countWords()
{
    for(int i=0; i<x; i++) {
        if(arrayWords[i]==' ' && arrayWords[i-1]!= ' ') //count number of spaces, ignores double spacing
            nWords++;
    }
    pc.printf("\n\rYour typing speed is: '%d' words per minute\n\r", nWords);
    //reset temp variables
    x=0;
    nWords=0;
    return;
}

void countWordsInterrupt() //Count words if reset button is pressed
{
    int k = t.read();
    //TODO Count
    for(int i=0; i<x; i++) {
        if(arrayWords[i]==' ' && arrayWords[i-1]!= ' ')
            nWords++;
    }
    nWords = 60/k*nWords;
    pc.printf("\n\rSeconds used typing before interrupted '%d'", k);
    pc.printf("\n\rTARDIS got interrupted, but it estimated your typing speed to be approximetly: '%d' words per minute\n\r", nWords);
    x=0;
    nWords=0;
    t.reset();
    k = t.read();
    return;
}

int main()
{
    
    interrupt.rise(&countWordsInterrupt);
    ticker.attach(&countWords, 60);
    while(true) {
        t.reset();
        t.start();
        while(t.read()<=60) {
            arrayWords[x] = pc.getc();
            x++;
        }
        t.stop();
        }
}