
/*
 * music.h
 *
 *  Created on: Feb "some day", 2014
 *     Authors: Arthur Semjonov && Jonathan Pucceti 
 */

#ifndef TARDIS_H_
#define TARDIS_H_
/*=====================NOTES=============================*/

enum NoteName {C0=0,Cs0,D0,Eb0,E0,F0,Fs0,G0,Gs0,A0,Bb0,B0,
                 C1,Cs1,D1,Eb1,E1,F1,Fs1,G1,Gs1,A1,Bb1,B1,
                 C2,Cs2,D2,Eb2,E2,F2,Fs2,G2,Gs2,A2,Bb2,B2,
                 C3,Cs3,D3,Eb3,E3,F3,Fs3,G3,Gs3,A3,Bb3,B3,
                 C4,Cs4,D4,Eb4,E4,F4,Fs4,G4,Gs4,A4,Bb4,B4,
                 C5,Cs5,D5,Eb5,E5,F5,Fs5,G5,Gs5,A5,Bb5,B5,
                 C6,Cs6,D6,Eb6,E6,F6,Fs6,G6,Gs6,A6,Bb6,B6,
                 C7,Cs7,D7,Eb7,E7,F7,Fs7,G7,Gs7,A7,Bb7,B7,
                 C8,Cs8,D8,Eb8,E8,F8,Fs8,G8,Gs8,A8,Bb8,B8,R};
/*=======================================================*/


/*=====================FREQUENCIES=======================*/
float notes[]={16.35,17.32,18.35,19.45,20.60,21.83,23.12,24.50,25.96,27.50,29.14,30.87,
               32.70,34.65,36.71,38.89,41.20,43.65,46.25,49.00,51.91,55.00,58.27,61.74,
               65.41,69.30,73.42,77.78,82.41,87.31,92.50,98.00,103.8,110.0,116.5,123.5,
               130.8,138.6,146.8,155.6,164.8,174.6,185.0,196.0,207.7,220.0,233.1,246.9,
               261.6,277.2,293.7,311.1,329.6,349.2,370.0,392.0,415.3,440.0,466.2,493.9,
               523.3,554.4,587.3,622.3,659.3,698.5,740.0,784.0,830.6,880.0,932.3,987.8,
               1047,1109,1175,1245,1319,1397,1480,1568,1661,1760,1865,1976,
               2093,2217,2349,2489,2637,2794,2960,3136,3322,3520,3729,3951,
               4186,4435,4699,4978,5274,5588,5920,6272,6645,7040,7459,7902};
               



/*=============================Prototypes===============*/
/*Demo song*/ 
void songOfMyPeople(float frequency[], float beat[]);


/** ___________________Used for demo___________________
 *  Look up the frequency of the note from music.h file
 *  @param frq[], array of the song
 *  @param k, location of the note in the array
 * _____________________________________________________
 */                    
float lookupNoteFrq(float frq[], int k);


//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=//

/* _________________________________________
 * Parses the note recevied by the I2C slave.
 * Helper function of playTheNote. Which takes and integer value and references the frequency
 * related to that note. After frequency is found, function plays the note.
 * @param k, music note
 * _________________________________________ */
void playTheNote(int k);

/* _________________________________________________________________________
 * I2C data link (Master) which sends notes of the song to linked slave mbed
 * while simultaniously playing the same note on it's own mbed
 * Features:
            1) Hold mid joystick to stop both master and slave
            2) When Slave button is pressed (joyDown), it will stop playing slave song and 
 ________________________________________________________________________________________*/
void playTheDoctor(void);

/* _____________________________________________________________________
 * I2C data link (Master) which reads notes of the song from a companion 
 * (slave) and plays the song of their people
 * Features:
            1) Hold mid joystick to stop both master and slave
            2) When Master button is pressed (joyUp), it will stop playing slave song and 
_________________________________________________________________________________________*/
void playTheCompanion(void);

#endif /* TARDIS_H_ */