#include "mbed.h"
#include "TARDIS_ARCHIVE.h"

/* @author: Arthur Semjonov 
 * @author: Jonathan Pucceti
 */ 
DigitalOut l(LED1), l2(LED2), l3(LED3), l4(LED4);
/********************************************************/
AnalogIn pitch(p19);                //Potentiometer sets up the pitch of the song
AnalogIn tempo(p20);                //Potentiometer to set tempo of the song
DigitalIn joyUP(p15);               //Play song of the Doctor (Master)
DigitalIn joyDOWN(p12);             //Play song of the Companion (Slave)
DigitalIn joyMID(p14);              //Stop playing either master or Slave song.
PwmOut speaker(p26);                //Speaker on the mbed

/*============SERIAL COMMUNICATION==============*/
I2CSlave companion(p9, p10);          //mosi/miso/sck of the Slave
/********************************************************/
Serial pc(USBTX, USBRX);
int send_note;                   //word we will send
int rec_note;                    //value received from master
const int addr = 0x42;

/************************************|Lost Woods|**********************************/
float frequency[]= {F4,A4,B4,F4,A4,B4,F4,A4,B4,E5,D5,B4,C5,B4,G4,E4,D4,E4,G4,E4};
float beat[]= {1,1,2,1,1,2,1,1,1,1,2,1,1,1,1,3,1,1,1,3};
/***************************************************************************************/


int main()
{
    //l4=1;
    int k;
    companion.address(addr);
    while(1) {
        k = companion.receive();
        if(k==3) {
            //k = companion.receive();
            playTheDoctor();
            //companion.stop();
        } else if(k==1) {
            //k = companion.receive();
            pc.printf("\n\rI am playing companion");

            playTheCompanion();
            pc.printf("\n\rStopped playing companion");
            companion.stop();
        }
    }
}
//========================================================================================================================================
//========================================================================================================================================
//========================================================================================================================================

/*********************************************************************
******************************THE COMPANION***************************
********************************aka slave*****************************
**********************************************************************/
/*TODO: 1) Figure out what stop() returns, if any
        2) Add print statements to see what is getting sent/received
        Bonus) Implement potentiameters for tempo and pitch */

void playTheCompanion()
{
    pc.printf("\n\rEntering Companion song");
    //int l = companion.receive();
    for (int i=0; i<=sizeof(frequency)/sizeof(int)-1; i++) {
        send_note = frequency[i];
        int check = companion.receive();
        pc.printf("\n\rCheck line = '%d'", check);
        if (check == 0xFF) {
            speaker = 0;
            pc.printf("\n\rKicked out of the TARDIS");
            return;
        }
        int t = companion.write(send_note);
        pc.printf("\n\rSending = '%d'", send_note );
        //int t = companion.write(send_note);

        float value = lookupNoteFrq(frequency, i);
        speaker.period(1/(2*value)); // set PWM period
        speaker=0.5;
        wait(0.4*beat[i]);

        //  if (joyMID) {
//            speaker = 0; //reset speaker duty cycle
//
//            wait(2);     //delay for inferior humans
//            return;
//        } else if(joyUP) {
//            speaker = 0;
//
//            pc.printf("\n\rInterrupted Companion song by the Master song");
//            return;
//        }
    }
    companion.write(0xFF);
    speaker = 0;

    pc.printf("\n\rExiting Companion song");
    return;
}

/*********************************************************************
******************************THE DOCTOR******************************
********************************aka master****************************
**********************************************************************/
/*TODO: 1) Make sure while loop condition is doing what it suppose to
        2) Initialize receive note, and play it
        3) Implement interrupts
        4) Stopping conditions
        Bonus) Potentiometers for pitch and tempo
*/
void playTheDoctor()
{
    int prev=0;
    int cur;
    pc.printf("\n\rEntering Doctors song\n\r=====================================");
    //speaker = 0.5;
    while (1) {

        rec_note = companion.read();
        cur = rec_note; 
        if(rec_note == 0xFF) {
            pc.printf("\n\rLeaveing the TARDIS :(, Doctor leaves for another couple of years >.>");
            companion.stop();
            speaker = 0;
            //rec_note=0xFF;
            wait(0.1);
            return;
        }
        //pc.printf("\n\rReceived '%d'", rec_note);
        if (cur != prev)playTheNote(rec_note);
        prev = cur; 
//
//
//        if (joyMID) {
//            speaker = 0;                    //reset speaker duty cycle
//            //force end condition for both master and companion
//            pc.printf("\n\rInterrupted doctor song by demo");
//            wait(2);                        //delay for inferior humans
//            return;
//        } else if(joyDOWN) {
//            speaker = 0;                   //read joyUp value.
//            //force end condition due to interuppt
//            pc.printf("\n\rInterrupted doctor song by Companion");
//            return;
//        }
    }
}
/*===================================================================*/
//===================Goon Squad of helper functions==================//
void playTheNote(int k)
{
    float frqNote = notes[k];
    pc.printf("\n\rNote I got = '%d", k);
    speaker.period(1/(2*frqNote)); // set PWM period
    speaker=0.5;
    return;
}

/*====================Original Demo====================================*/
void songOfMyPeople(float frequency[], float beat[])
{
    pc.printf("\n\rSong of my people");
    while(1) { //run infinetly unless interupted
        for (int i=0; i<=19; i++) {
            float value = lookupNoteFrq(frequency, i);
            speaker.period(1/(2*value)); // set PWM period
            speaker=0.5; // set duty cycle
            wait(0.4*beat[i]);
            if (joyMID) {
                speaker = 0; //reset speaker duty cycle
                wait(2);     //delay for inferior humans
                return;
            }
        }
        speaker = 0;
        wait(0.25);
    }
}

/*===================================================================*/
float lookupNoteFrq(float frq[], int k)
{
    int location_of_note = frequency[k];
    pc.printf("\n\rLocation of the note = '%d'", location_of_note);

    float vNote = notes[location_of_note];
    pc.printf("\n\rFrq of the note = '%f'", vNote);
    return vNote;
}