#include "mbed.h"
#include "TARDIS_ARCHIVE.h"
DigitalOut l(LED1), l2(LED2), l3(LED3), l4(LED4);
/********************************************************/
AnalogIn pitch(p19);                //Potentiometer sets up the pitch of the song
AnalogIn tempo(p20);                //Potentiometer to set tempo of the song
DigitalIn joyUP(p15);               //Play song of the Doctor (Master)
DigitalIn joyDOWN(p12);             //Play song of the Companion (Slave)
DigitalIn joyMID(p14);              //Stop playing either master or Slave song.
PwmOut speaker(p26);                //Speaker on the mbed

/*============SERIAL COMMUNICATION==============*/
I2C doctor(p9, p10);           //mosi/miso/sck of the Doctor
/********************************************************/
Serial pc(USBTX, USBRX);
int send_note;                   //word we will send
int rec_note;                    //value received from master
const int addr = 0x42;
const int stop = 0xFF;
/************************************|I Am the Doctor|**********************************/
float frequency[]= {D3, E3, F3, G3,
                    F3 ,E3, D3, E3, D3
                   };
float beat[]= {.7,.7,.7,0.3,.7,.7,.7,0.3,0.3, 0.3};
/***************************************************************************************/
//
int main()
{

    while(1) {

        if (joyUP) {
            playTheDoctor();
            doctor.stop();
            wait(0.01);
        } else if (joyDOWN) {

            playTheCompanion();
            wait(0.01);
        } else if (joyMID) {
//            pc.printf("\n\rMAIN PROGRAM OF THE DOCTOR INITIATED");
//
//            doctor.start();
//            doctor.write(addr);
//            int j = frequency[4];
//            int k = doctor.write(F3);
//            pc.printf("\n\rHi = '%d'", j);
//            doctor.stop();
            songOfMyPeople(frequency, beat);
            // wait(2);
        }
        wait (0.01);
    }
}
//========================================================================================================================================
//========================================================================================================================================
//========================================================================================================================================

/*********************************************************************
******************************THE COMPANION***************************
********************************aka slave*****************************
**********************************************************************/

void playTheCompanion()
{
    doctor.start();
    //doctor.read(addr);
    doctor.write(addr|0x01);
//send address, with R/W bit set to Read
    int prev=0;
    int cur;
    while(1) {
        rec_note = doctor.read(addr);
        cur = rec_note;
        if(rec_note==stop) {
            speaker = 0;
            //doctor.write(addr|0x00);
            doctor.stop();
            return;
        }
        if(cur!=prev) playTheCompanion(cur);
        prev = rec_note;
        //wait(0.01);
        if (joyMID) {
            speaker = 0;                    //reset speaker duty cycle
            doctor.write(stop);
            doctor.stop();
            wait(1);                        //delay for inferior humans
            return;
        } else if(joyUP) {
            speaker = 0;                   //read joyUp value.
            doctor.write(stop);
            doctor.stop();
            return;

        }
    }
//speaker = 0;

//return;
}

/*********************************************************************
******************************THE DOCTOR******************************
********************************aka master****************************
**********************************************************************/

void playTheDoctor()
{
    doctor.start();
    doctor.write(addr);
    for (int i=0; i<=sizeof(frequency)/sizeof(int)-1; i++) {
        send_note = frequency[i];
        doctor.write(send_note);
        pc.printf("\n\rDoctor sent note = '%d", send_note);
        float value = lookupNoteFrq(frequency, i);
        speaker.period(1/(2*value)); // set PWM period
        speaker=0.5;
        wait(0.4*beat[i]);

        if (joyMID) {
            pc.printf("\n\rDoctor song was interrupted by demo");
            speaker = 0; //reset speaker duty cycle
            doctor.stop();
            wait(2);     //delay for inferior humans
            return;
        } else if(joyDOWN) {
            speaker = 0;
            doctor.stop();
            return;
        }
    }
    doctor.write(stop);
    doctor.stop();
    speaker=0;
    return;
}
/*===================================================================*/
//===================Goon Squad of helper functions==================//
void playTheCompanion(int k)
{
    float frqNote = notes[k];
    pc.printf("\n\rNote I got = '%d", k);
    speaker.period(1/(2*frqNote)); // set PWM period
    speaker=0.5;
    return;
}

/*====================Original Demo====================================*/
void songOfMyPeople(float frequency[], float beat[])

{
    while(1) { //run infinetly unless interupted
        for (int i=0; i<=8; i++) {
            float value = lookupNoteFrq(frequency, i);
            speaker.period(1/(2*value)); // set PWM period
            speaker=0.5; // set duty cycle
            wait(0.4*beat[i]);
            if (joyMID) {
                speaker = 0; //reset speaker duty cycle
                wait(2);     //delay for inferior humans
                return;
            }
        }
        speaker = 0;
        wait(0.25);
    }
}

/*===================================================================*/
float lookupNoteFrq(float frq[], int k)
{
    int location_of_note = frequency[k];
    pc.printf("\n\rLocation of the note = '%d'", location_of_note);

    float vNote = notes[location_of_note];
    pc.printf("\n\rFrq of the note = '%f'", vNote);
    return vNote;
}