#include "mbed.h"
#include "songs.h"


/*******LED brightness value range from 0 to 1***********/
PwmOut r (p23);                     //red
PwmOut g (p24);                     //greeb
PwmOut b (p25);                     //blue
/********************************************************/
AnalogIn p1(p19);                   //Potentiometers left (red)
AnalogIn p2(p20);                   //Potentiometers right (green)
DigitalIn joyUP(p15);               //Adds blue button
DigitalIn joyDOWN(p12);             //Subtracts blue button
DigitalIn joyMID(p14);              //Play the song button

Songs play; //song object

/*************************************I Am the Doctor***********************************/
float frequency[]= {146.83, 164.81, 174.61, 196, 174.61 ,164.81, 146.83, 164.81, 146.83};
float beat[]= {.9,.9,.9,0.5,.9,.9,.9,0.5,0.5, 0.5};
/***************************************************************************************/

int main()
{
    while(1) {
        r = p1; //read left potentiometer and set red light 
        g = p2; //read right potentiometer and set green light
        if (joyUP) {
            b = (b>0) ? b-0.01: b; //if blue > 0, then subtract 0.01 from brightness value
            wait(0.01);
        } else if (joyDOWN) {
            b = (b<1) ? b+0.01: b; //if blue < 1, then add 0.01 to brightness value
            wait(0.01);
        } else if (joyMID) {
            play.songOfMyPeople(frequency, beat); //play the song
            wait(0.01);
        }
        wait (0.01);
    }
}