/*
 * song.cpp
 *
 *  Created on: Feb 11, 2014
 *      Author: Artur Semjonov
 */

#include "mbed.h"
#include "songs.h"


PwmOut speaker(p26);
DigitalIn off(p14); // middle joystick used to turn off the song
Songs::Songs() {}

void Songs::songOfMyPeople(float frequency[], float beat[])
{
   while(1) { //run infinetly unless interupted
        for (int i=0; i<=8; i++) {
            speaker.period(1/(2*frequency[i])); // set PWM period
            speaker=0.5; // set duty cycle
            wait(0.4*beat[i]);
            if (off) {
                speaker = 0; //reset speaker duty cycle
                wait(2);     //delay for inferior humans
                return; 
            }
        }
        speaker = 0;
        wait(0.25);
    }
}