#ifndef ST7580_H
#define ST7580_H

#include "mbed.h"
#include "ST7580_codes.h"
#include <stdio.h>
#include <string.h>

#define ST7580_TSR 100

/*! \class ST7580
* \brief ST7580 driver
*
*  here is a minimal example:
*  void callback_function(unsigned char *data, int payload_length)
*  {
*       //Do what you want with the data
*  }
*  int main() {
*    ST7580 shield(D8, D2, D13, D7, callback_function);
*    shield.init();
*    wait(1);
*    while(1) {
*        shield.send_frame("Hello world!");
*    }
* }
*/
class ST7580 
{
    public:
        /*!
         *  \brief Constructor
         *
         *  ST7580 Constructor
         *
         *  \param tx : mbed UART transmission pin
         *  \param rx : mbed UART reception pin
         *  \param t_req : ST7580 transmit request pin
         *  \param reset : ST7580 reset pin
         *  \param usr_callback : callback to the user app with reception buffer, and payload length as arguments
         */
        ST7580(PinName tx, PinName rx, PinName t_req, PinName reset,  void (*usr_callback)(unsigned char *, int));
        
        /*!
         *  \brief Initialises the pins and UART needed for the driver
         *
         *  Creates the UART handle and needed pins
         */
        void init();
        void send_frame(unsigned char *msg, int msg_length);

    private:
        void wait_status();
        void wait_reset();
        void reset_reception_buffer();
        void rx_complete();
        void rx_callback();

        void (*_usr_callback)(unsigned char *, int);
        volatile unsigned char _rx_char;
        volatile unsigned char _rcv_data[255];
        volatile int _rcv_data_idx;
        volatile int _rcv_data_offset;
        volatile int _rcv_payload_len;

        DigitalOut  *_plm_t_req;
        DigitalOut  *_plm_reset;
        RawSerial   *_plm_uart;
};

#endif
