/* L298HBridge Library v1.0
 * Copyright (c) 2017 Armand Coetzer
 * s213293048@nmmu.ac.za
 *
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
 
#ifndef L298HBridge_H
#define L298HBridge_H
 
#include "mbed.h"
 
/** Class library for a L298 H-Bridge.
 *
 * Example:
 * @code
 * #include "mbed.h"
 * #include "L298HBridge.h"
 *
 * L298HBridge dcmotor(PA_5, PA_6, PA_10); //Create a L298HBridge object with enable pin on PA5, Fwd pin or PA6 and Rev pin on PA10
 *
 * int main() 
 * {
 *    while(1)
 *    {
 *          dcmotor.Fwd();               //setting the motor to spin forward
 *          dcmotor.SetSpeed(0.5);       //setting the speed the motor will spin
 *    }    
 * }
 * @endcode
 */
 
class L298HBridge {
  public:
    /** Create a L298HBridge object connected to the specified pins. Once created, The pins still need
    * to be set to a direction and also the speed via PWM.
    * @param ENpin PwmOut compatible pin used to set the speed of the motor.
    * @param FWDpin Used to spin the motor in the forward direction.
    * @param REVDpin Used to spin the motor in the Reverse direction.
    */
    L298HBridge(PinName ENpin, PinName FWDpin, PinName REVpin);
    
    /** Setting the DC motor to spin in the forward direction.
    * @param 
    *     None
    */
    void Fwd();
    
    /** Setting the DC motor to spin in the Revers direction.
    * @param 
    *     None
    */
    void Rev();
    
     /** Stopping the motor.
    * @param 
    *     None
    */
    void Stop();
    
     /** Set the speed of the motor.
    * @param 
    *     PWMPercentage, variable to set te speed of the motor (any value from 0.1 - 1).
    * @return
    *     None
    */
    void SetSpeed(float PWMPercentage);
 
  private:
    PwmOut _en;
    DigitalOut _fwd, _rev;
};
 
#endif
