#include "L298HBridge.h"
#include "mbed.h"
 
L298HBridge::L298HBridge(PinName ENpin, PinName FWDpin, PinName REVpin) : _en(ENpin), _fwd(FWDpin), _rev(REVpin) 
{
    _fwd = 0;
    _rev = 0;
    _en = 0.0;
}
 
void L298HBridge::Fwd() 
{    
    _fwd = 1;
    _rev = 0;
}

void L298HBridge::Rev() 
{
    _fwd = 0;
    _rev = 1;
}

void L298HBridge::Stop() 
{
    _fwd = 1;
    _rev = 1;
}


 
void L298HBridge::SetSpeed(float PWMPercentage) 
{
    _en = PWMPercentage;
}
       