#include "F7_TSKeypad_MultiKey.h"
#include "mbed.h"

F7_TSKeypad_MultiKey::F7_TSKeypad_MultiKey()
{
    btnsize = 50;
    state = 0;
    key = 0;
    
    status = ts.Init(lcd.GetXSize(), lcd.GetYSize());
    if (status != TS_OK) 
    {
        lcd.Clear(LCD_COLOR_RED);
        lcd.SetBackColor(LCD_COLOR_RED);
        lcd.SetTextColor(LCD_COLOR_WHITE);
        lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN INIT FAIL", CENTER_MODE);
        while(1);
    }
    else 
    {
        OK = 1;
        
    }
    
    ticker.attach(callback(this, &F7_TSKeypad_MultiKey::Detect_isr),0.01);
}

void F7_TSKeypad_MultiKey::Detect_isr()
{             
    
    if(OK)
    {       
        ts.GetState(&TS_State);
        
        if (TS_State.touchDetected) 
        {            
            
        ///////////////////////check correct touch//////////////////////////////////////////////////////////////
            if(TS_State.touchX[0]>= keypadstartX[0][0] && TS_State.touchX[0]<= keypadendX[0][0] && TS_State.touchY[0]>= keypadstartY[0][0] && TS_State.touchY[0]<= keypadendY[0][0] && keypad == 1)
            {
                correcttouch = 1;
                button = 1;    
                lcd.SetTextColor(LCD_COLOR_GRAY); 
                lcd.FillRect(keypadstartX[0][0], keypadstartY[0][0], btnsize, btnsize);                   
            }
            else if(TS_State.touchX[0]>= keypadstartX[0][1] && TS_State.touchX[0]<= keypadendX[0][1] && TS_State.touchY[0]>= keypadstartY[0][1] && TS_State.touchY[0]<= keypadendY[0][1] && keypad == 1)
            {
                correcttouch = 1;
                button = 2;
                lcd.SetTextColor(LCD_COLOR_GRAY); 
                lcd.FillRect(keypadstartX[0][1], keypadstartY[0][1], btnsize, btnsize); 
            }
            else if(TS_State.touchX[0]>= keypadstartX[0][2] && TS_State.touchX[0]<= keypadendX[0][2] && TS_State.touchY[0]>= keypadstartY[0][2] && TS_State.touchY[0]<= keypadendY[0][2] && keypad == 1)
            {
                correcttouch = 1;
                button = 3;
                lcd.SetTextColor(LCD_COLOR_GRAY); 
                lcd.FillRect(keypadstartX[0][2], keypadstartY[0][2], btnsize, btnsize); 
            }
            else if(TS_State.touchX[0]>= keypadstartX[0][3] && TS_State.touchX[0]<= keypadendX[0][3] && TS_State.touchY[0]>= keypadstartY[0][3] && TS_State.touchY[0]<= keypadendY[0][3] && keypad == 1)
            {
                correcttouch = 1;
                button = 4;
                lcd.SetTextColor(LCD_COLOR_GRAY); 
                lcd.FillRect(keypadstartX[0][3], keypadstartY[0][3], btnsize, btnsize); 
            }
            else if(TS_State.touchX[0]>= keypadstartX[1][0] && TS_State.touchX[0]<= keypadendX[1][0] && TS_State.touchY[0]>= keypadstartY[1][0] && TS_State.touchY[0]<= keypadendY[1][0] && keypad == 1)
            {
                correcttouch = 1;
                button = 5;
                lcd.SetTextColor(LCD_COLOR_GRAY); 
                lcd.FillRect(keypadstartX[1][0], keypadstartY[1][0], btnsize, btnsize); 
            }
            else if(TS_State.touchX[0]>= keypadstartX[1][1] && TS_State.touchX[0]<= keypadendX[1][1] && TS_State.touchY[0]>= keypadstartY[1][1] && TS_State.touchY[0]<= keypadendY[1][1] && keypad == 1)
            {
                correcttouch = 1;
                button = 6;
                lcd.SetTextColor(LCD_COLOR_GRAY); 
                lcd.FillRect(keypadstartX[1][1], keypadstartY[1][1], btnsize, btnsize); 
            }
            else if(TS_State.touchX[0]>= keypadstartX[1][2] && TS_State.touchX[0]<= keypadendX[1][2] && TS_State.touchY[0]>= keypadstartY[1][2] && TS_State.touchY[0]<= keypadendY[1][2] && keypad == 1)
            {
                correcttouch = 1;
                button = 7;
                lcd.SetTextColor(LCD_COLOR_GRAY); 
                lcd.FillRect(keypadstartX[1][2], keypadstartY[1][2], btnsize, btnsize); 
            }
            else if(TS_State.touchX[0]>= keypadstartX[1][3] && TS_State.touchX[0]<= keypadendX[1][3] && TS_State.touchY[0]>= keypadstartY[1][3] && TS_State.touchY[0]<= keypadendY[1][3] && keypad == 1)
            {
                correcttouch = 1;
                button = 8;
                lcd.SetTextColor(LCD_COLOR_GRAY); 
                lcd.FillRect(keypadstartX[1][3], keypadstartY[1][3], btnsize, btnsize); 
            }
            else if(TS_State.touchX[0]>= keypadstartX[2][0] && TS_State.touchX[0]<= keypadendX[2][0] && TS_State.touchY[0]>= keypadstartY[2][0] && TS_State.touchY[0]<= keypadendY[2][0] && keypad == 1)
            {
                correcttouch = 1;
                button = 9;
                lcd.SetTextColor(LCD_COLOR_GRAY); 
                lcd.FillRect(keypadstartX[2][0], keypadstartY[2][0], btnsize, btnsize); 
            }
            else if(TS_State.touchX[0]>= keypadstartX[2][1] && TS_State.touchX[0]<= keypadendX[2][1] && TS_State.touchY[0]>= keypadstartY[2][1] && TS_State.touchY[0]<= keypadendY[2][1] && keypad == 1)
            {
                correcttouch = 1;
                button = 10;
                lcd.SetTextColor(LCD_COLOR_GRAY); 
                lcd.FillRect(keypadstartX[2][1], keypadstartY[2][1], btnsize, btnsize); 
            }
            else if(TS_State.touchX[0]>= keypadstartX[2][2] && TS_State.touchX[0]<= keypadendX[2][2] && TS_State.touchY[0]>= keypadstartY[2][2] && TS_State.touchY[0]<= keypadendY[2][2] && keypad == 1)
            {
                correcttouch = 1;
                button = 11;
                lcd.SetTextColor(LCD_COLOR_GRAY); 
                lcd.FillRect(keypadstartX[2][2], keypadstartY[2][2], btnsize, btnsize); 
            }
            else if(TS_State.touchX[0]>= keypadstartX[2][3] && TS_State.touchX[0]<= keypadendX[2][3] && TS_State.touchY[0]>= keypadstartY[2][3] && TS_State.touchY[0]<= keypadendY[2][3] && keypad == 1)
            {
                correcttouch = 1; 
                button = 12;
                lcd.SetTextColor(LCD_COLOR_GRAY); 
                lcd.FillRect(keypadstartX[2][3], keypadstartY[2][3], btnsize, btnsize); 
            }
            else if(TS_State.touchX[0]>= keypadstartX[3][0] && TS_State.touchX[0]<= keypadendX[3][0] && TS_State.touchY[0]>= keypadstartY[3][0] && TS_State.touchY[0]<= keypadendY[3][0] && keypad == 1)
            {
                correcttouch = 1;
                button = 13;
                lcd.SetTextColor(LCD_COLOR_GRAY); 
                lcd.FillRect(keypadstartX[3][0], keypadstartY[3][0], btnsize, btnsize); 
            }
            else if(TS_State.touchX[0]>= keypadstartX[3][1] && TS_State.touchX[0]<= keypadendX[3][1] && TS_State.touchY[0]>= keypadstartY[3][1] && TS_State.touchY[0]<= keypadendY[3][1] && keypad == 1)
            {
               correcttouch = 1; 
               button = 14;  
               lcd.SetTextColor(LCD_COLOR_GRAY); 
               lcd.FillRect(keypadstartX[3][1], keypadstartY[3][1], btnsize, btnsize);  
            }
            else if(TS_State.touchX[0]>= keypadstartX[3][2] && TS_State.touchX[0]<= keypadendX[3][2] && TS_State.touchY[0]>= keypadstartY[3][2] && TS_State.touchY[0]<= keypadendY[3][2] && keypad == 1)
            {
               correcttouch = 1; 
               button = 15;
               lcd.SetTextColor(LCD_COLOR_GRAY); 
               lcd.FillRect(keypadstartX[3][2], keypadstartY[3][2], btnsize, btnsize);    
            }
            else if(TS_State.touchX[0]>= keypadstartX[3][3] && TS_State.touchX[0]<= keypadendX[3][3] && TS_State.touchY[0]>= keypadstartY[3][3] && TS_State.touchY[0]<= keypadendY[3][3] && keypad == 1)
            {
               correcttouch = 1; 
               button = 16;
               lcd.SetTextColor(LCD_COLOR_GRAY); 
               lcd.FillRect(keypadstartX[3][3], keypadstartY[3][3], btnsize, btnsize);    
            }
            else if(TS_State.touchX[0]>= keypadstartX[0][3] + 60 && TS_State.touchX[0]<= keypadendX[0][3] + 60 && TS_State.touchY[0]>= keypadstartY[0][3] && TS_State.touchY[0]<= keypadendY[0][3] && keypad == 1)
            {
               correcttouch = 1; 
               button = 17;
               lcd.SetTextColor(LCD_COLOR_GRAY); 
               lcd.FillRect(keypadstartX[0][3] + 60, keypadstartY[0][3], btnsize, btnsize);    
            }
            else if(TS_State.touchX[0]>= keypadstartX[1][3] + 60 && TS_State.touchX[0]<= keypadendX[1][3] + 60 && TS_State.touchY[0]>= keypadstartY[1][3] && TS_State.touchY[0]<= keypadendY[1][3] + 120 && keypad == 1)
            {
               correcttouch = 1; 
               button = 18;
               lcd.SetTextColor(LCD_COLOR_GRAY); 
               lcd.FillRect(keypadstartX[1][3] + 60, keypadstartY[1][3], btnsize, 170);    
            }
            else
            {
                correcttouch = 0;  
                button = 0;                 
            }  
        //////////////////////////////////////////////////////////////////////////////////////////////////////      
        }
    }
}
 
void F7_TSKeypad_MultiKey::getkeys(char str[], uint8_t startx, uint8_t starty,char char1, char char2, char char3, char char4, char char5, char char6,  char char7, char char8, char char9, char char10, char char11, char char12, char char13, char char14, char char15, char char16)
{   
    uint8_t text2[40];

    Bckclr    = lcd.GetBackColor();
    Txtclr    = lcd.GetTextColor();
    *FontSize = *lcd.GetFont();
    
    lcd.ClearStringLine(0);
    DrawKeypad(startx, starty, char1, char2, char3, char4, char5, char6,  char7, char8, char9, char10, char11, char12, char13, char14, char15, char16);
    
    while(Enter != 1)
    {     
        wait(0.0001);
           
        switch(state)
        {////////check if pressed on screen///////
            case 0:
            {
                if(TS_State.touchDetected)
                {  
                    frstprsx = TS_State.touchX[0];
                    frstprsy = TS_State.touchY[0];
                    state = 10;
                }
             ////////////////////////////////////////              
            }break;
            ////////check if correctly pressed//////////
            case 10:
            {                
                for(b = 0; b < 4; b++)
                {
                    for(a = 0; a < 4; a++)
                    {
                        if(frstprsx >= keypadstartX[a][b] && frstprsx <= keypadendX[a][b] && frstprsy >= keypadstartY[a][b] && frstprsy <= keypadendY[a][b] || frstprsx >= keypadstartX[0][3] + 60 && frstprsx <= keypadendX[0][3] + 60 && frstprsy >= keypadstartY[0][3] && frstprsy <= keypadendY[0][3] || frstprsx >= keypadstartX[1][3] + 60 && frstprsx <= keypadendX[1][3] + 60 && frstprsy >= keypadstartY[1][3] && frstprsy <= keypadendY[1][3] + 120)
                        {   
                            state = 15;
                            correcttouch = 1;
                            key = button;
                            a = 3;
                            b = 3;
                        }
                        else
                        {   
                            state = 30; 
                        }
                    }    
                }
                             
            }break;
            case 15:
            {  
                if(button == key && button != 0)
                {     
                    if(TS_State.touchDetected == 0)
                    {  
                        DrawKeypad(startx, starty, char1, char2, char3, char4, char5, char6,  char7, char8, char9, char10, char11, char12, char13, char14, char15, char16);
                        state = 20;                
                    }                    
                }
                else if(button != key || button == 0)
                {   
                    state = 30;
                } 
                
            }break; 
            ////////////button functions//////////
            case 20:
            {   ////////button 1/////////////
                if(button == 1)
                {   
                    keypressed = char1;
                    a = 0;
                    b = 0;
                    correcttouch = 0;
                    state = 0;
                }    
                else if(button == 2)
                {   
                    keypressed = char2;
                    a = 0;
                    b = 0;
                    correcttouch = 0;
                    state = 0;
                }  
                else if(button == 3)
                {   
                    keypressed = char3;
                    a = 0;
                    b = 0;
                    correcttouch = 0;
                    state = 0;
                }    
                else if(button == 4)
                {   
                    keypressed = char4;
                    a = 0;
                    b = 0;
                    correcttouch = 0;
                    state = 0;
                }  
                else if(button == 5)
                {   
                    keypressed = char5;
                    a = 0;
                    b = 0;
                    correcttouch = 0;
                    state = 0;
                }    
                else if(button == 6)
                {   
                    keypressed = char6;
                    a = 0;
                    b = 0;
                    correcttouch = 0;
                    state = 0;
                }    
                else if(button == 7)
                {   
                    keypressed = char7;
                    a = 0;
                    b = 0;
                    correcttouch = 0;
                    state = 0;
                }    
                else if(button == 8)
                {   
                    keypressed = char8;
                    a = 0;
                    b = 0;
                    correcttouch = 0;
                    state = 0;
                }    
                else if(button == 9)
                {   
                    keypressed = char9;
                    a = 0;
                    b = 0;
                    correcttouch = 0;
                    state = 0;
                }    
                else if(button == 10)
                {   
                    keypressed = char10;
                    a = 0;
                    b = 0;
                    correcttouch = 0;
                    state = 0;
                }    
                else if(button == 11)
                {   
                    keypressed = char11;
                    a = 0;
                    b = 0;
                    correcttouch = 0;
                    state = 0;
                }    
                else if(button == 12)
                {   
                    keypressed = char12;
                    a = 0;
                    b = 0;
                    correcttouch = 0;
                    state = 0;
                }    
                else if(button == 13)
                {   
                    keypressed = char13;
                    a = 0;
                    b = 0;
                    correcttouch = 0;
                    state = 0;
                }    
                else if(button == 14)
                {   
                    keypressed = char14;
                    a = 0;
                    b = 0;
                    correcttouch = 0;
                    state = 0;
                }    
                else if(button == 15)
                {   
                    keypressed = char15;
                    a = 0;
                    b = 0;
                    correcttouch = 0;
                    state = 0;
                }    
                else if(button == 16)
                {   
                    keypressed = char16;
                    a = 0;
                    b = 0;
                    correcttouch = 0;
                    state = 0;
                }   
                else if(button == 17)
                {   
                    keypressed = ' ';
                    
                    if(m != 0 || textx != 0)
                    {
                        m -= 1;
                        textx -= 12;
                    }
                    
                    a = 0;
                    b = 0;
                    correcttouch = 0;
                    state = 0;
                }       
                else if(button == 18)
                {   
                    keypressed = '\0';
                    Enter = 1;
                    a = 0;
                    b = 0;
                    correcttouch = 0;
                    state = 0;
                }           
                
                str[m] =  keypressed;
                
                lcd.SetTextColor(Txtclr);
                lcd.SetBackColor(Bckclr);
                lcd.SetFont(&Font20);
                sprintf((char*)text2, "%c", str[m]);
                lcd.DisplayStringAt(0 + textx, LINE(0), (uint8_t *)&text2, LEFT_MODE);
                    
                if(keypressed != ' ')
                {
                    m++;
                    textx += 12;
                }             
                
                key = 0;
                
            }break; 
            case 30:
            {
                if(keypad == 1)
                {
                    DrawKeypad(startx, starty, char1, char2, char3, char4, char5, char6,  char7, char8, char9, char10, char11, char12, char13, char14, char15, char16);
                    keypad = 0;
                }
                
                if(TS_State.touchDetected == 0)
                {  
                    DrawKeypad(startx, starty, char1, char2, char3, char4, char5, char6,  char7, char8, char9, char10, char11, char12, char13, char14, char15, char16);
                    TS_State.touchX[0]= 0;
                    TS_State.touchY[0]= 0;
                    a = 0;
                    b = 0;
                    correcttouch = 0;
                    state = 0;
                }
            }break;             
        } 
    }
    
    keypad = 0;
    Enter = 0;
    m = 0;
    textx = 0;
    state = 0;
    lcd.ClearStringLine(0);
    lcd.SetTextColor(Bckclr);
    lcd.FillRect(keypadstartX[0][0],keypadstartY[0][0], 290, 230);
    lcd.SetTextColor(Txtclr);
    lcd.SetFont(FontSize);
}

void F7_TSKeypad_MultiKey::DrawKeypad(uint8_t startpointx, uint8_t startpointy,char char1, char char2, char char3, char char4, char char5, char char6,  char char7, char char8, char char9, char char10, char char11, char char12, char char13, char char14, char char15, char char16)
{    
    int i, o, stepx = 0, stepy = 0, Drawpointx, Drawpointy;
    uint8_t text[30];
    
    char keyval[4][4] = {{char1, char2, char3, char4},
                         {char5, char6, char7, char8},
                         {char9, char10, char11, char12},
                         {char13, char14, char15, char16}
                        };
    keypad = 1;
    
    for(o= 0; o< 4; o++)
    {
        for(i= 0; i < 4; i++)
        {  
            lcd.SetTextColor(LCD_COLOR_WHITE);
             
            lcd.FillRect(Drawpointx = startpointx + stepx, Drawpointy  = startpointy + stepy, btnsize, btnsize);
            keypadstartX[i][o] = Drawpointx;
            keypadstartY[i][o] = Drawpointy;
            keypadendX[i][o] = Drawpointx + 50;
            keypadendY[i][o] = Drawpointy + 50;
            stepy += 60;
            
            lcd.SetBackColor(LCD_COLOR_WHITE);
            lcd.SetTextColor(LCD_COLOR_BLACK);
            lcd.SetFont(&Font20);
            sprintf((char*)text, "%c", keyval[i][o]);
            lcd.DisplayStringAt(Drawpointx+ 20, Drawpointy+ 20, (uint8_t *)&text, LEFT_MODE);
            
            
            if(stepy > 180)
            {
                stepy = 0;
            }       
        }  
        
        stepx += 60;     
    }
    
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.FillRect(keypadstartX[0][3] + 60, keypadstartY[0][3], btnsize, btnsize);
    lcd.FillRect(keypadstartX[1][3] + 60, keypadstartY[1][3], btnsize, 170);
    
    lcd.SetBackColor(LCD_COLOR_WHITE);
    lcd.SetTextColor(LCD_COLOR_BLACK);
    
    sprintf((char*)text, "<");
    lcd.DisplayStringAt(keypadstartX[0][3] + 80, keypadstartY[0][3] + 20, (uint8_t *)&text, LEFT_MODE);
    sprintf((char*)text, "E");
    lcd.DisplayStringAt(keypadstartX[1][3] + 80, keypadstartY[1][3] + 35, (uint8_t *)&text, LEFT_MODE);
    sprintf((char*)text, "N");
    lcd.DisplayStringAt(keypadstartX[0][3] + 80, keypadstartY[1][3] + 55, (uint8_t *)&text, LEFT_MODE);
    sprintf((char*)text, "T");
    lcd.DisplayStringAt(keypadstartX[0][3] + 80, keypadstartY[1][3] + 75, (uint8_t *)&text, LEFT_MODE);
    sprintf((char*)text, "E");
    lcd.DisplayStringAt(keypadstartX[0][3] + 80, keypadstartY[1][3] + 95, (uint8_t *)&text, LEFT_MODE);
    sprintf((char*)text, "R");
    lcd.DisplayStringAt(keypadstartX[0][3] + 80, keypadstartY[1][3] + 115, (uint8_t *)&text, LEFT_MODE);
    
    lcd.SetTextColor(Txtclr);
    lcd.SetBackColor(Bckclr);
    lcd.SetFont(FontSize);
}       