/* F7 TS Keypad Multi Key Library v1.0
 * Copyright (c) 2017 Armand Coetzer
 * s213293048@nmmu.ac.za
 *
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
 
#ifndef F7_TSKeypad_MultiKey_H
#define F7_TSKeypad_MultiKey_H
 
#include "mbed.h"
#include "LCD_DISCO_F746NG.h"
#include "TS_DISCO_F746NG.h"

/** Class library for a TS Keypad and retrieving multiple keys, then press enter and the values are stored and the keypad disappears.
 *
 * Example:
 * @code
 *#include "mbed.h"
 *#include "F7_TSKeypad_MultiKey.h"

 *F7_TSKeypad_MultiKey keypad;
 *LCD_DISCO_F746NG lcd;
 *
 *uint8_t text1[30];
 *char s[100];
 *
 *int main() 
 *{    
 *    lcd.SetFont(&Font12);
 *    lcd.Clear(LCD_COLOR_BLUE);
 *    lcd.SetBackColor(LCD_COLOR_BLUE);
 *    lcd.SetTextColor(LCD_COLOR_WHITE);  
 * 
 *    while(1)
 *    {
 *        keypad.getkeys(s, 170, 20, 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P');
 *        
 *        sprintf((char*)text1, "%s", s);
 *        lcd.DisplayStringAt(0, LINE(5), (uint8_t *)&text1, LEFT_MODE);   
 *         
 *        wait(1);  
 *    }
 *}
 * @endcode
 */
 
 class F7_TSKeypad_MultiKey 
 {
   
  public:
    /** Constructor. 
    */
    F7_TSKeypad_MultiKey();
    
    /** Retrieves the keys selected as a string.
    * @param  str[] - stores the keys selected in this array.
    * @param  startx - to set x start pos of the keypad.
    * @param  starty - to set y start pos of the keypad.
    * @param  char1 - char16 to change the keys of the keypad.
    * @retval None.
    */
    void getkeys(char str[], uint8_t startx, uint8_t starty,char char1, char char2, char char3, char char4, char char5, char char6,  char char7, char char8, char char9, char char10, char char11, char char12, char char13, char char14, char char15, char char16);

  private:
  
    void Detect_isr();
    void DrawKeypad(uint8_t startpointx, uint8_t startpointy,char char1, char char2, char char3, char char4, char char5, char char6,  char char7, char char8, char char9, char char10, char char11, char char12, char char13, char char14, char char15, char char16);
    
    Ticker ticker;
    sFONT *FontSize;
    LCD_DISCO_F746NG lcd;
    TS_DISCO_F746NG ts;
    TS_StateTypeDef TS_State;
        
    uint8_t state, btnsize;
    int OK; 
    uint32_t Bckclr, Txtclr;
    uint8_t correcttouch, button, key;
    uint16_t frstprsx, frstprsy;
    char keypressed;
    int a, b, recv;
    int keypad;
    int keypadstartX[4][4];
    int keypadstartY[4][4];
    int keypadendX[4][4];
    int keypadendY[4][4];
    uint8_t status;
    int m, textx, Enter;    
};
 
#endif
