#include "F7_TSKeyboard.h"
#include "mbed.h"

F7_TSKeyboard::F7_TSKeyboard()
{
    btnsize = 35;
    state = 0;
    key = 0;
    Caps = 0;
    Func = 0;
    
    status = ts.Init(lcd.GetXSize(), lcd.GetYSize());
    if (status != TS_OK) 
    {
        lcd.Clear(LCD_COLOR_RED);
        lcd.SetBackColor(LCD_COLOR_RED);
        lcd.SetTextColor(LCD_COLOR_WHITE);
        lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN INIT FAIL", CENTER_MODE);
        while(1);
    }
    else 
    {
        OK = 1;
        
    }
    
    ticker.attach(callback(this, &F7_TSKeyboard::Detect_isr),0.01);
}

void F7_TSKeyboard::Detect_isr()
{                 
    if(OK)
    {       
        ts.GetState(&TS_State);
        
        if (TS_State.touchDetected) 
        {            
            
        ///////////////////////check correct touch//////////////////////////////////////////////////////////////
            if(TS_State.touchX[0]>= KeyboardstartX[0][0] && TS_State.touchX[0]<= KeyboardendX[0][0] && TS_State.touchY[0]>= KeyboardstartY[0][0] && TS_State.touchY[0]<= KeyboardendY[0][0] && Keyboard == 1)
            {
                correcttouch = 1;
                button = 1; 
                if(button == key)
                {   
                    lcd.SetTextColor(LCD_COLOR_GRAY); 
                    lcd.FillRect(KeyboardstartX[0][0], KeyboardstartY[0][0], btnsize, btnsize);     
                }
                                 
            }
            else if(TS_State.touchX[0]>= KeyboardstartX[0][1] && TS_State.touchX[0]<= KeyboardendX[0][1] && TS_State.touchY[0]>= KeyboardstartY[0][1] && TS_State.touchY[0]<= KeyboardendY[0][1] && Keyboard == 1)
            {
                correcttouch = 1;
                button = 2;
                if(button == key)
                {
                    lcd.SetTextColor(LCD_COLOR_GRAY); 
                    lcd.FillRect(KeyboardstartX[0][1], KeyboardstartY[0][1], btnsize, btnsize); 
                }
            }
            else if(TS_State.touchX[0]>= KeyboardstartX[0][2] && TS_State.touchX[0]<= KeyboardendX[0][2] && TS_State.touchY[0]>= KeyboardstartY[0][2] && TS_State.touchY[0]<= KeyboardendY[0][2] && Keyboard == 1)
            {
                correcttouch = 1;
                button = 3;
                if(button == key)
                {
                    lcd.SetTextColor(LCD_COLOR_GRAY); 
                    lcd.FillRect(KeyboardstartX[0][2], KeyboardstartY[0][2], btnsize, btnsize);
                } 
            }
            else if(TS_State.touchX[0]>= KeyboardstartX[0][3] && TS_State.touchX[0]<= KeyboardendX[0][3] && TS_State.touchY[0]>= KeyboardstartY[0][3] && TS_State.touchY[0]<= KeyboardendY[0][3] && Keyboard == 1)
            {
                correcttouch = 1;
                button = 4;
                if(button == key)
                {
                    lcd.SetTextColor(LCD_COLOR_GRAY); 
                    lcd.FillRect(KeyboardstartX[0][3], KeyboardstartY[0][3], btnsize, btnsize); 
                }
            }
            else if(TS_State.touchX[0]>= KeyboardstartX[0][4] && TS_State.touchX[0]<= KeyboardendX[0][4] && TS_State.touchY[0]>= KeyboardstartY[0][4] && TS_State.touchY[0]<= KeyboardendY[0][4] && Keyboard == 1)
            {
                correcttouch = 1;
                button = 5;
                if(button == key)
                {
                    lcd.SetTextColor(LCD_COLOR_GRAY); 
                    lcd.FillRect(KeyboardstartX[0][4], KeyboardstartY[0][4], btnsize, btnsize);
                } 
            }
            else if(TS_State.touchX[0]>= KeyboardstartX[0][5] && TS_State.touchX[0]<= KeyboardendX[0][5] && TS_State.touchY[0]>= KeyboardstartY[0][5] && TS_State.touchY[0]<= KeyboardendY[0][5] && Keyboard == 1)
            {
                correcttouch = 1;
                button = 6;
                if(button == key)
                {
                    lcd.SetTextColor(LCD_COLOR_GRAY); 
                    lcd.FillRect(KeyboardstartX[0][5], KeyboardstartY[0][5], btnsize, btnsize); 
                }
            }
            else if(TS_State.touchX[0]>= KeyboardstartX[0][6] && TS_State.touchX[0]<= KeyboardendX[0][6] && TS_State.touchY[0]>= KeyboardstartY[0][6] && TS_State.touchY[0]<= KeyboardendY[0][6] && Keyboard == 1)
            {
                correcttouch = 1;
                button = 7;
                if(button == key)
                {
                    lcd.SetTextColor(LCD_COLOR_GRAY); 
                    lcd.FillRect(KeyboardstartX[0][6], KeyboardstartY[0][6], btnsize, btnsize);
                } 
            }
            else if(TS_State.touchX[0]>= KeyboardstartX[0][7] && TS_State.touchX[0]<= KeyboardendX[0][7] && TS_State.touchY[0]>= KeyboardstartY[0][7] && TS_State.touchY[0]<= KeyboardendY[0][7] && Keyboard == 1)
            {
                correcttouch = 1;
                button = 8;
                if(button == key)
                {
                    lcd.SetTextColor(LCD_COLOR_GRAY); 
                    lcd.FillRect(KeyboardstartX[0][7], KeyboardstartY[0][7], btnsize, btnsize);
                } 
            }
            else if(TS_State.touchX[0]>= KeyboardstartX[0][8] && TS_State.touchX[0]<= KeyboardendX[0][8] && TS_State.touchY[0]>= KeyboardstartY[0][8] && TS_State.touchY[0]<= KeyboardendY[0][8] && Keyboard == 1)
            {
                correcttouch = 1;
                button = 9;
                if(button == key)
                {
                    lcd.SetTextColor(LCD_COLOR_GRAY); 
                    lcd.FillRect(KeyboardstartX[0][8], KeyboardstartY[0][8], btnsize, btnsize); 
                }
            }
            else if(TS_State.touchX[0]>= KeyboardstartX[0][9] && TS_State.touchX[0]<= KeyboardendX[0][9] && TS_State.touchY[0]>= KeyboardstartY[0][9] && TS_State.touchY[0]<= KeyboardendY[0][9] && Keyboard == 1)
            {
                correcttouch = 1;
                button = 10;
                lcd.SetTextColor(LCD_COLOR_GRAY); 
                lcd.FillRect(KeyboardstartX[0][9], KeyboardstartY[0][9], btnsize, btnsize); 
            }
            else if(TS_State.touchX[0]>= KeyboardstartX[1][0] && TS_State.touchX[0]<= KeyboardendX[1][0] && TS_State.touchY[0]>= KeyboardstartY[1][0] && TS_State.touchY[0]<= KeyboardendY[1][0] && Keyboard == 1)
            {
                correcttouch = 1;
                button = 11;
                lcd.SetTextColor(LCD_COLOR_GRAY); 
                lcd.FillRect(KeyboardstartX[1][0], KeyboardstartY[1][0], btnsize, btnsize); 
            }
            else if(TS_State.touchX[0]>= KeyboardstartX[1][1] && TS_State.touchX[0]<= KeyboardendX[1][1] && TS_State.touchY[0]>= KeyboardstartY[1][1] && TS_State.touchY[0]<= KeyboardendY[1][1] && Keyboard == 1)
            {
                correcttouch = 1;
                button = 12;
                lcd.SetTextColor(LCD_COLOR_GRAY); 
                lcd.FillRect(KeyboardstartX[1][1], KeyboardstartY[1][1], btnsize, btnsize); 
            }
            else if(TS_State.touchX[0]>= KeyboardstartX[1][2] && TS_State.touchX[0]<= KeyboardendX[1][2] && TS_State.touchY[0]>= KeyboardstartY[1][2] && TS_State.touchY[0]<= KeyboardendY[1][2] && Keyboard == 1)
            {
                correcttouch = 1;
                button = 13;
                lcd.SetTextColor(LCD_COLOR_GRAY); 
                lcd.FillRect(KeyboardstartX[1][2], KeyboardstartY[1][2], btnsize, btnsize); 
            }
            else if(TS_State.touchX[0]>= KeyboardstartX[1][3] && TS_State.touchX[0]<= KeyboardendX[1][3] && TS_State.touchY[0]>= KeyboardstartY[1][3] && TS_State.touchY[0]<= KeyboardendY[1][3] && Keyboard == 1)
            {
                correcttouch = 1;
                button = 14;
                lcd.SetTextColor(LCD_COLOR_GRAY); 
                lcd.FillRect(KeyboardstartX[1][3], KeyboardstartY[1][3], btnsize, btnsize); 
            }
            else if(TS_State.touchX[0]>= KeyboardstartX[1][4] && TS_State.touchX[0]<= KeyboardendX[1][4] && TS_State.touchY[0]>= KeyboardstartY[1][4] && TS_State.touchY[0]<= KeyboardendY[1][4] && Keyboard == 1)
            {
                correcttouch = 1;
                button = 15;
                lcd.SetTextColor(LCD_COLOR_GRAY); 
                lcd.FillRect(KeyboardstartX[1][4], KeyboardstartY[1][4], btnsize, btnsize); 
            }
            else if(TS_State.touchX[0]>= KeyboardstartX[1][5] && TS_State.touchX[0]<= KeyboardendX[1][5] && TS_State.touchY[0]>= KeyboardstartY[1][5] && TS_State.touchY[0]<= KeyboardendY[1][5] && Keyboard == 1)
            {
                correcttouch = 1;
                button = 16;
                lcd.SetTextColor(LCD_COLOR_GRAY); 
                lcd.FillRect(KeyboardstartX[1][5], KeyboardstartY[1][5], btnsize, btnsize); 
            }
            else if(TS_State.touchX[0]>= KeyboardstartX[1][6] && TS_State.touchX[0]<= KeyboardendX[1][6] && TS_State.touchY[0]>= KeyboardstartY[1][6] && TS_State.touchY[0]<= KeyboardendY[1][6] && Keyboard == 1)
            {
                correcttouch = 1;
                button = 17;
                lcd.SetTextColor(LCD_COLOR_GRAY); 
                lcd.FillRect(KeyboardstartX[1][6], KeyboardstartY[1][6], btnsize, btnsize); 
            }
            else if(TS_State.touchX[0]>= KeyboardstartX[1][7] && TS_State.touchX[0]<= KeyboardendX[1][7] && TS_State.touchY[0]>= KeyboardstartY[1][7] && TS_State.touchY[0]<= KeyboardendY[1][7] && Keyboard == 1)
            {
                correcttouch = 1;
                button = 18;
                lcd.SetTextColor(LCD_COLOR_GRAY); 
                lcd.FillRect(KeyboardstartX[1][7], KeyboardstartY[1][7], btnsize, btnsize); 
            }
            else if(TS_State.touchX[0]>= KeyboardstartX[1][8] && TS_State.touchX[0]<= KeyboardendX[1][8] && TS_State.touchY[0]>= KeyboardstartY[1][8] && TS_State.touchY[0]<= KeyboardendY[1][8] && Keyboard == 1)
            {
                correcttouch = 1;
                button = 19;
                lcd.SetTextColor(LCD_COLOR_GRAY); 
                lcd.FillRect(KeyboardstartX[1][8], KeyboardstartY[1][8], btnsize, btnsize); 
            }
            else if(TS_State.touchX[0]>= KeyboardstartX[1][9] && TS_State.touchX[0]<= KeyboardendX[1][9] && TS_State.touchY[0]>= KeyboardstartY[1][9] && TS_State.touchY[0]<= KeyboardendY[1][9] && Keyboard == 1)
            {
                correcttouch = 1;
                button = 20;
                lcd.SetTextColor(LCD_COLOR_GRAY); 
                lcd.FillRect(KeyboardstartX[1][9], KeyboardstartY[1][9], btnsize, btnsize); 
            }
            else if(TS_State.touchX[0]>= KeyboardstartX[2][0] && TS_State.touchX[0]<= KeyboardendX[2][0] && TS_State.touchY[0]>= KeyboardstartY[2][0] && TS_State.touchY[0]<= KeyboardendY[2][0] && Keyboard == 1)
            {
                correcttouch = 1;
                button = 21;
                lcd.SetTextColor(LCD_COLOR_GRAY); 
                lcd.FillRect(KeyboardstartX[2][0], KeyboardstartY[2][0], btnsize, btnsize); 
            }
            else if(TS_State.touchX[0]>= KeyboardstartX[2][1] && TS_State.touchX[0]<= KeyboardendX[2][1] && TS_State.touchY[0]>= KeyboardstartY[2][1] && TS_State.touchY[0]<= KeyboardendY[2][1] && Keyboard == 1)
            {
                correcttouch = 1;
                button = 22;
                lcd.SetTextColor(LCD_COLOR_GRAY); 
                lcd.FillRect(KeyboardstartX[2][1], KeyboardstartY[2][1], btnsize, btnsize); 
            }
            else if(TS_State.touchX[0]>= KeyboardstartX[2][2] && TS_State.touchX[0]<= KeyboardendX[2][2] && TS_State.touchY[0]>= KeyboardstartY[2][2] && TS_State.touchY[0]<= KeyboardendY[2][2] && Keyboard == 1)
            {
                correcttouch = 1;
                button = 23;
                lcd.SetTextColor(LCD_COLOR_GRAY); 
                lcd.FillRect(KeyboardstartX[2][2], KeyboardstartY[2][2], btnsize, btnsize); 
            }
            else if(TS_State.touchX[0]>= KeyboardstartX[2][3] && TS_State.touchX[0]<= KeyboardendX[2][3] && TS_State.touchY[0]>= KeyboardstartY[2][3] && TS_State.touchY[0]<= KeyboardendY[2][3] && Keyboard == 1)
            {
                correcttouch = 1; 
                button = 24;
                lcd.SetTextColor(LCD_COLOR_GRAY); 
                lcd.FillRect(KeyboardstartX[2][3], KeyboardstartY[2][3], btnsize, btnsize); 
            }
            else if(TS_State.touchX[0]>= KeyboardstartX[2][4] && TS_State.touchX[0]<= KeyboardendX[2][4] && TS_State.touchY[0]>= KeyboardstartY[2][4] && TS_State.touchY[0]<= KeyboardendY[2][4] && Keyboard == 1)
            {
                correcttouch = 1;
                button = 25;
                lcd.SetTextColor(LCD_COLOR_GRAY); 
                lcd.FillRect(KeyboardstartX[2][4], KeyboardstartY[2][4], btnsize, btnsize); 
            }
            else if(TS_State.touchX[0]>= KeyboardstartX[2][5] && TS_State.touchX[0]<= KeyboardendX[2][5] && TS_State.touchY[0]>= KeyboardstartY[2][5] && TS_State.touchY[0]<= KeyboardendY[2][5] && Keyboard == 1)
            {
                correcttouch = 1;
                button = 26;
                lcd.SetTextColor(LCD_COLOR_GRAY); 
                lcd.FillRect(KeyboardstartX[2][5], KeyboardstartY[2][5], btnsize, btnsize); 
            }
            else if(TS_State.touchX[0]>= KeyboardstartX[2][6] && TS_State.touchX[0]<= KeyboardendX[2][6] && TS_State.touchY[0]>= KeyboardstartY[2][6] && TS_State.touchY[0]<= KeyboardendY[2][6] && Keyboard == 1)
            {
                correcttouch = 1;
                button = 27;
                lcd.SetTextColor(LCD_COLOR_GRAY); 
                lcd.FillRect(KeyboardstartX[2][6], KeyboardstartY[2][6], btnsize, btnsize); 
            }
            else if(TS_State.touchX[0]>= KeyboardstartX[2][7] && TS_State.touchX[0]<= KeyboardendX[2][7] && TS_State.touchY[0]>= KeyboardstartY[2][7] && TS_State.touchY[0]<= KeyboardendY[2][7] && Keyboard == 1)
            {
                correcttouch = 1;
                button = 28;
                lcd.SetTextColor(LCD_COLOR_GRAY); 
                lcd.FillRect(KeyboardstartX[2][7], KeyboardstartY[2][7], btnsize, btnsize); 
            }
            else if(TS_State.touchX[0]>= KeyboardstartX[2][8] && TS_State.touchX[0]<= KeyboardendX[2][8] && TS_State.touchY[0]>= KeyboardstartY[2][8] && TS_State.touchY[0]<= KeyboardendY[2][8] && Keyboard == 1)
            {
                correcttouch = 1;
                button = 29;
                lcd.SetTextColor(LCD_COLOR_GRAY); 
                lcd.FillRect(KeyboardstartX[2][8], KeyboardstartY[2][8], btnsize, btnsize); 
            }
            else if(TS_State.touchX[0]>= KeyboardstartX[2][9] && TS_State.touchX[0]<= KeyboardendX[2][9] && TS_State.touchY[0]>= KeyboardstartY[2][9] && TS_State.touchY[0]<= KeyboardendY[2][9] && Keyboard == 1)
            {
                correcttouch = 1;
                button = 30;
                lcd.SetTextColor(LCD_COLOR_GRAY); 
                lcd.FillRect(KeyboardstartX[2][9], KeyboardstartY[2][9], btnsize, btnsize); 
            }
            else if(TS_State.touchX[0]>= KeyboardstartX[3][0] && TS_State.touchX[0]<= KeyboardendX[3][0] && TS_State.touchY[0]>= KeyboardstartY[3][0] && TS_State.touchY[0]<= KeyboardendY[3][0] && Keyboard == 1)
            {
                correcttouch = 1;
                button = 31;
                lcd.SetTextColor(LCD_COLOR_GRAY); 
                lcd.FillRect(KeyboardstartX[3][0], KeyboardstartY[3][0], btnsize, btnsize); 
            }
            else if(TS_State.touchX[0]>= KeyboardstartX[3][1] && TS_State.touchX[0]<= KeyboardendX[3][1] && TS_State.touchY[0]>= KeyboardstartY[3][1] && TS_State.touchY[0]<= KeyboardendY[3][1] && Keyboard == 1)
            {
               correcttouch = 1; 
               button = 32;  
               lcd.SetTextColor(LCD_COLOR_GRAY); 
               lcd.FillRect(KeyboardstartX[3][1], KeyboardstartY[3][1], btnsize, btnsize);  
            }
            else if(TS_State.touchX[0]>= KeyboardstartX[3][2] && TS_State.touchX[0]<= KeyboardendX[3][2] && TS_State.touchY[0]>= KeyboardstartY[3][2] && TS_State.touchY[0]<= KeyboardendY[3][2] && Keyboard == 1)
            {
               correcttouch = 1; 
               button = 33;
               lcd.SetTextColor(LCD_COLOR_GRAY); 
               lcd.FillRect(KeyboardstartX[3][2], KeyboardstartY[3][2], btnsize, btnsize);    
            }
            else if(TS_State.touchX[0]>= KeyboardstartX[3][3] && TS_State.touchX[0]<= KeyboardendX[3][3] && TS_State.touchY[0]>= KeyboardstartY[3][3] && TS_State.touchY[0]<= KeyboardendY[3][3] && Keyboard == 1)
            {
               correcttouch = 1; 
               button = 34;
               lcd.SetTextColor(LCD_COLOR_GRAY); 
               lcd.FillRect(KeyboardstartX[3][3], KeyboardstartY[3][3], btnsize, btnsize);    
            }
            else if(TS_State.touchX[0]>= KeyboardstartX[3][4] && TS_State.touchX[0]<= KeyboardendX[3][4] && TS_State.touchY[0]>= KeyboardstartY[3][4] && TS_State.touchY[0]<= KeyboardendY[3][4] && Keyboard == 1)
            {
                correcttouch = 1;
                button = 35;
                lcd.SetTextColor(LCD_COLOR_GRAY); 
                lcd.FillRect(KeyboardstartX[3][4], KeyboardstartY[3][4], btnsize, btnsize); 
            }
            else if(TS_State.touchX[0]>= KeyboardstartX[3][5] && TS_State.touchX[0]<= KeyboardendX[3][5] && TS_State.touchY[0]>= KeyboardstartY[3][5] && TS_State.touchY[0]<= KeyboardendY[3][5] && Keyboard == 1)
            {
                correcttouch = 1;
                button = 36;
                lcd.SetTextColor(LCD_COLOR_GRAY); 
                lcd.FillRect(KeyboardstartX[3][5], KeyboardstartY[3][5], btnsize, btnsize); 
            }
            else if(TS_State.touchX[0]>= KeyboardstartX[3][6] && TS_State.touchX[0]<= KeyboardendX[3][6] && TS_State.touchY[0]>= KeyboardstartY[3][6] && TS_State.touchY[0]<= KeyboardendY[3][6] && Keyboard == 1)
            {
                correcttouch = 1;
                button = 37;
                lcd.SetTextColor(LCD_COLOR_GRAY); 
                lcd.FillRect(KeyboardstartX[3][6], KeyboardstartY[3][6], btnsize, btnsize); 
            }
            else if(TS_State.touchX[0]>= KeyboardstartX[3][7] && TS_State.touchX[0]<= KeyboardendX[3][7] && TS_State.touchY[0]>= KeyboardstartY[3][7] && TS_State.touchY[0]<= KeyboardendY[3][7] && Keyboard == 1)
            {
                correcttouch = 1;
                button = 38;
                lcd.SetTextColor(LCD_COLOR_GRAY); 
                lcd.FillRect(KeyboardstartX[3][7], KeyboardstartY[3][7], btnsize, btnsize); 
            }
            else if(TS_State.touchX[0]>= KeyboardstartX[3][8] && TS_State.touchX[0]<= KeyboardendX[3][8] && TS_State.touchY[0]>= KeyboardstartY[3][8] && TS_State.touchY[0]<= KeyboardendY[3][8] && Keyboard == 1)
            {
                correcttouch = 1;
                button = 39;
                lcd.SetTextColor(LCD_COLOR_GRAY); 
                lcd.FillRect(KeyboardstartX[3][8], KeyboardstartY[3][8], btnsize, btnsize); 
            }
            else if(TS_State.touchX[0]>= KeyboardstartX[3][9] && TS_State.touchX[0]<= KeyboardendX[3][9] && TS_State.touchY[0]>= KeyboardstartY[3][9] && TS_State.touchY[0]<= KeyboardendY[3][9] && Keyboard == 1)
            {
                correcttouch = 1;
                button = 40;
                lcd.SetTextColor(LCD_COLOR_GRAY); 
                lcd.FillRect(KeyboardstartX[3][9], KeyboardstartY[3][9], btnsize, btnsize); 
            }
            else if(TS_State.touchX[0]>= KeyboardstartX[3][2] && TS_State.touchX[0]<= KeyboardendX[3][2] + 190 && TS_State.touchY[0]>= KeyboardstartY[3][2] + 38 && TS_State.touchY[0]<= KeyboardendY[3][2] + 38 && Keyboard == 1)
            {
               correcttouch = 1; 
               button = 41;
               lcd.SetTextColor(LCD_COLOR_GRAY); 
               lcd.FillRect(KeyboardstartX[3][2], KeyboardstartY[3][2] + 38, 225, btnsize);    
            }
            else if(TS_State.touchX[0]>= KeyboardstartX[3][0] && TS_State.touchX[0]<= KeyboardendX[3][0] + 38 && TS_State.touchY[0]>= KeyboardstartY[3][0] + 38 && TS_State.touchY[0]<= KeyboardendY[3][0] + 38 && Keyboard == 1)
            {
               correcttouch = 1; 
               button = 42;
               lcd.SetTextColor(LCD_COLOR_GRAY); 
               lcd.FillRect(KeyboardstartX[3][0], KeyboardstartY[3][0] + 38, 73, btnsize);    
            }
            else if(TS_State.touchX[0]>= KeyboardstartX[3][8] && TS_State.touchX[0]<= KeyboardendX[3][8] && TS_State.touchY[0]>= KeyboardstartY[3][8] + 38 && TS_State.touchY[0]<= KeyboardendY[3][8] + 38 && Keyboard == 1)
            {
               correcttouch = 1; 
               button = 43;
               lcd.SetTextColor(LCD_COLOR_GRAY); 
               lcd.FillRect(KeyboardstartX[3][8], KeyboardstartY[3][8] + 38, btnsize, btnsize);    
            }
            else if(TS_State.touchX[0]>= KeyboardstartX[3][9] && TS_State.touchX[0]<= KeyboardendX[3][9] + 38 && TS_State.touchY[0]>= KeyboardstartY[3][9] + 38 && TS_State.touchY[0]<= KeyboardendY[3][9] + 38 && Keyboard == 1)
            {
               correcttouch = 1; 
               button = 44;
               lcd.SetTextColor(LCD_COLOR_GRAY); 
               lcd.FillRect(KeyboardstartX[3][9], KeyboardstartY[3][9] + 38, 73, btnsize);    
            }
            else if(TS_State.touchX[0]>= KeyboardstartX[0][9] + 38 && TS_State.touchX[0]<= KeyboardendX[0][9] + 38 && TS_State.touchY[0]>= KeyboardstartY[0][9] && TS_State.touchY[0]<= KeyboardendY[0][9] + 38 && Keyboard == 1)
            {
               correcttouch = 1; 
               button = 45;
               lcd.SetTextColor(LCD_COLOR_GRAY); 
               lcd.FillRect(KeyboardstartX[0][9] + 38, KeyboardstartY[0][9], btnsize, 73);    
            }
            else if(TS_State.touchX[0]>= KeyboardstartX[2][9] + 38 && TS_State.touchX[0]<= KeyboardendX[2][9] + 38 && TS_State.touchY[0]>= KeyboardstartY[2][9] && TS_State.touchY[0]<= KeyboardendY[2][9] + 38 && Keyboard == 1)
            {
               correcttouch = 1; 
               button = 46;
               lcd.SetTextColor(LCD_COLOR_GRAY); 
               lcd.FillRect(KeyboardstartX[2][9] + 38, KeyboardstartY[2][9], btnsize, 73);    
            }
            else
            {
                correcttouch = 0;  
                button = 0;                 
            }  
        //////////////////////////////////////////////////////////////////////////////////////////////////////      
        }
    }
}
 
void F7_TSKeyboard::getkeys(char str[])
{   
    uint8_t text2[40];

    Bckclr    = lcd.GetBackColor();
    Txtclr    = lcd.GetTextColor();
    *FontSize = *lcd.GetFont();
    
    lcd.ClearStringLine(0);
    DrawKeyboard();
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.FillRect(0, 0, 480, 20);
    
    while(Enter != 1)
    {     
        wait(0.0001);
           
        switch(state)
        {////////check if pressed on screen///////
            case 0:
            {
                if(TS_State.touchDetected)
                {  
                    frstprsx = TS_State.touchX[0];
                    frstprsy = TS_State.touchY[0];
                    state = 10;
                }
             ////////////////////////////////////////              
            }break;
            ////////check if correctly pressed//////////
            case 10:
            {                
                for(b = 0; b < 10; b++)
                {
                    for(a = 0; a < 4; a++)
                    {
                        if(frstprsx >= KeyboardstartX[a][b] && frstprsx <= KeyboardendX[a][b] && frstprsy >= KeyboardstartY[a][b] && frstprsy <= KeyboardendY[a][b] || frstprsx >= KeyboardstartX[3][2] && frstprsx <= KeyboardendX[3][2] + 190 && frstprsy >= KeyboardstartY[3][2] + 38 && frstprsy <= KeyboardendY[3][2] + 38 || frstprsx >= KeyboardstartX[3][0] && frstprsx <= KeyboardendX[3][0] + 38 && frstprsy >= KeyboardstartY[3][0] + 38 && frstprsy <= KeyboardendY[3][0] + 38 || frstprsx >= KeyboardstartX[3][8] && frstprsx <= KeyboardendX[3][8] && frstprsy >= KeyboardstartY[3][8] + 38 && frstprsy <= KeyboardendY[3][8] + 38 || frstprsx >= KeyboardstartX[3][9] && frstprsx <= KeyboardendX[3][9] + 38 && frstprsy >= KeyboardstartY[3][9] + 38 && frstprsy <= KeyboardendY[3][9] + 38 || frstprsx >= KeyboardstartX[0][9] + 38 && frstprsx <= KeyboardendX[0][9] + 38 && frstprsy >= KeyboardstartY[0][9] && frstprsy <= KeyboardendY[0][9] + 38 || frstprsx >= KeyboardstartX[2][9] + 38 && frstprsx <= KeyboardendX[2][9] + 38 && frstprsy >= KeyboardstartY[2][9] && frstprsy <= KeyboardendY[2][9] + 38)
                        {   
                            state = 15;
                            correcttouch = 1;
                            key = button; 
                            a = 9;
                            b = 9;
                        }
                        else
                        {   
                            state = 30; 
                        }
                    }    
                }
                             
            }break;
            case 15:
            {  
                if(button == key && button != 0)
                {     
                    if(TS_State.touchDetected == 0)
                    {  
                        DrawKeyboard();
                        state = 20;               
                    }                    
                }
                else if(button != key || button == 0)
                {   
                    state = 30;
                } 
                
            }break; 
            ////////////button functions//////////
            case 20:
            {   ////////button 1/////////////
                if(button == 1)
                {   
                    if(Func == 1 && Caps == 0)
                    {
                        keypressed = '@';
                    }
                    else
                    {
                        keypressed = '1';
                    }
                    a = 0;
                    b = 0;
                    correcttouch = 0;
                    state = 0;
                }    
                else if(button == 2)
                {   
                    if(Func == 1 && Caps == 0)
                    {
                        keypressed = '#';
                    }
                    else
                    {
                        keypressed = '2';
                    }
                    a = 0;
                    b = 0;
                    correcttouch = 0;
                    state = 0;
                }  
                else if(button == 3)
                {   
                    if(Func == 1 && Caps == 0)
                    {
                        keypressed = '$';
                    }
                    else
                    {
                        keypressed = '3';
                    }
                    a = 0;
                    b = 0;
                    correcttouch = 0;
                    state = 0;
                }    
                else if(button == 4)
                {   
                    if(Func == 1 && Caps == 0)
                    {
                        keypressed = '%';
                    }
                    else
                    {
                        keypressed = '4';
                    }
                    a = 0;
                    b = 0;
                    correcttouch = 0;
                    state = 0;
                }  
                else if(button == 5)
                {   
                    if(Func == 1 && Caps == 0)
                    {
                        keypressed = 38;
                    }
                    else
                    {
                        keypressed = '5';
                    }
                    a = 0;
                    b = 0;
                    correcttouch = 0;
                    state = 0;
                }    
                else if(button == 6)
                {   
                    if(Func == 1 && Caps == 0)
                    {
                        keypressed = '*';
                    }
                    else
                    {
                        keypressed = '6';
                    }
                    a = 0;
                    b = 0;
                    correcttouch = 0;
                    state = 0;
                }    
                else if(button == 7)
                {   
                    if(Func == 1 && Caps == 0)
                    {
                        keypressed = '(';
                    }
                    else
                    {
                        keypressed = '7';
                    }
                    a = 0;
                    b = 0;
                    correcttouch = 0;
                    state = 0;
                }    
                else if(button == 8)
                {   
                    if(Func == 1 && Caps == 0)
                    {
                        keypressed = ')';
                    }
                    else
                    {
                        keypressed = '8';
                    }
                    a = 0;
                    b = 0;
                    correcttouch = 0;
                    state = 0;
                }    
                else if(button == 9)
                {   
                    if(Func == 1 && Caps == 0)
                    {
                        keypressed = '-';
                    }
                    else
                    {
                        keypressed = '9';
                    }
                    a = 0;
                    b = 0;
                    correcttouch = 0;
                    state = 0;
                }    
                else if(button == 10)
                {   
                    if(Func == 1 && Caps == 0)
                    {
                        keypressed = '+';
                    }
                    else
                    {
                        keypressed = '0';
                    }
                    a = 0;
                    b = 0;
                    correcttouch = 0;
                    state = 0;
                }    
                else if(button == 11)
                {   
                    if(Func == 1 && Caps == 0)
                    {
                        keypressed = '=';
                    }
                    else if(Caps == 1 && Func == 0)
                    {
                        keypressed = 'Q';
                    }
                    else
                    {
                        keypressed = 'q';
                    }
                    a = 0;
                    b = 0;
                    correcttouch = 0;
                    state = 0;
                }    
                else if(button == 12)
                {   
                    if(Func == 1 && Caps == 0)
                    {
                        keypressed = '_';
                    }
                    else if(Caps == 1 && Func == 0)
                    {
                        keypressed = 'W';
                    }
                    else
                    {
                        keypressed = 'w';
                    }
                    a = 0;
                    b = 0;
                    correcttouch = 0;
                    state = 0;
                }    
                else if(button == 13)
                {   
                    if(Func == 1 && Caps == 0)
                    {
                        keypressed = '^';
                    }
                    else if(Caps == 1 && Func == 0)
                    {
                        keypressed = 'E';
                    }
                    else
                    {
                        keypressed = 'e';
                    }
                    a = 0;
                    b = 0;
                    correcttouch = 0;
                    state = 0;
                }    
                else if(button == 14)
                {   
                    if(Func == 1 && Caps == 0)
                    {
                        keypressed = ';';
                    }
                    else if(Caps == 1 && Func == 0)
                    {
                        keypressed = 'R';
                    }
                    else
                    {
                        keypressed = 'r';
                    }
                    a = 0;
                    b = 0;
                    correcttouch = 0;
                    state = 0;
                }    
                else if(button == 15)
                {   
                    if(Func == 1 && Caps == 0)
                    {
                        keypressed = '"';
                    }
                    else if(Caps == 1 && Func == 0)
                    {
                        keypressed = 'T';
                    }
                    else
                    {
                        keypressed = 't';
                    }
                    a = 0;
                    b = 0;
                    correcttouch = 0;
                    state = 0;
                }    
                else if(button == 16)
                {   
                    if(Func == 1 && Caps == 0)
                    {
                        keypressed = '\'';
                    }
                    else if(Caps == 1 && Func == 0)
                    {
                        keypressed = 'Y';
                    }
                    else
                    {
                        keypressed = 'y';
                    }
                    a = 0;
                    b = 0;
                    correcttouch = 0;
                    state = 0;
                }   
                else if(button == 17)
                {   
                    if(Func == 1 && Caps == 0)
                    {
                        keypressed = '<';
                    }
                    else if(Caps == 1 && Func == 0)
                    {
                        keypressed = 'U';
                    }
                    else
                    {
                        keypressed = 'u';
                    }
                    a = 0;
                    b = 0;
                    correcttouch = 0;
                    state = 0;
                }   
                else if(button == 18)
                {   
                    if(Func == 1 && Caps == 0)
                    {
                        keypressed = '>';
                    }
                    else if(Caps == 1 && Func == 0)
                    {
                        keypressed = 'I';
                    }
                    else
                    {
                        keypressed = 'i';
                    }
                    a = 0;
                    b = 0;
                    correcttouch = 0;
                    state = 0;
                }   
                else if(button == 19)
                {   
                    if(Func == 1 && Caps == 0)
                    {
                        keypressed = '/';
                    }
                    else if(Caps == 1 && Func == 0)
                    {
                        keypressed = 'O';
                    }
                    else
                    {
                        keypressed = 'o';
                    }
                    a = 0;
                    b = 0;
                    correcttouch = 0;
                    state = 0;
                }   
                else if(button == 20)
                {   
                    if(Func == 1 && Caps == 0)
                    {
                        keypressed = '\\';
                    }
                    else if(Caps == 1 && Func == 0)
                    {
                        keypressed = 'P';
                    }
                    else
                    {
                        keypressed = 'p';
                    }
                    a = 0;
                    b = 0;
                    correcttouch = 0;
                    state = 0;
                }   
                else if(button == 21)
                {   
                    if(Func == 1 && Caps == 0)
                    {
                        keypressed = ' ';
                    }
                    else
                    {
                        keypressed = ':';
                    }
                    a = 0;
                    b = 0;
                    correcttouch = 0;
                    state = 0;
                }    
                else if(button == 22)
                {   
                    if(Func == 1 && Caps == 0)
                    {
                        keypressed = ' ';
                    }
                    else if(Caps == 1 && Func == 0)
                    {
                        keypressed = 'A';
                    }
                    else
                    {
                        keypressed = 'a';
                    }
                    a = 0;
                    b = 0;
                    correcttouch = 0;
                    state = 0;
                }  
                else if(button == 23)
                {   
                    if(Func == 1 && Caps == 0)
                    {
                        keypressed = '`';
                    }
                    else if(Caps == 1 && Func == 0)
                    {
                        keypressed = 'S';
                    }
                    else
                    {
                        keypressed = 's';
                    }
                    a = 0;
                    b = 0;
                    correcttouch = 0;
                    state = 0;
                }    
                else if(button == 24)
                {   
                    if(Func == 1 && Caps == 0)
                    {
                        keypressed = '~';
                    }
                    else if(Caps == 1 && Func == 0)
                    {
                        keypressed = 'D';
                    }
                    else
                    {
                        keypressed = 'd';
                    }
                    a = 0;
                    b = 0;
                    correcttouch = 0;
                    state = 0;
                }  
                else if(button == 25)
                {   
                    if(Func == 1 && Caps == 0)
                    {
                        keypressed = '{';
                    }
                    else if(Caps == 1 && Func == 0)
                    {
                        keypressed = 'F';
                    }
                    else
                    {
                        keypressed = 'f';
                    }
                    a = 0;
                    b = 0;
                    correcttouch = 0;
                    state = 0;
                }    
                else if(button == 26)
                {   
                    if(Func == 1 && Caps == 0)
                    {
                        keypressed = '}';
                    }
                    else if(Caps == 1 && Func == 0)
                    {
                        keypressed = 'G';
                    }
                    else
                    {
                        keypressed = 'g';
                    }
                    a = 0;
                    b = 0;
                    correcttouch = 0;
                    state = 0;
                }    
                else if(button == 27)
                {   
                    if(Func == 1 && Caps == 0)
                    {
                        keypressed = '[';
                    }
                    else if(Caps == 1 && Func == 0)
                    {
                        keypressed = 'H';
                    }
                    else
                    {
                        keypressed = 'h';
                    }
                    a = 0;
                    b = 0;
                    correcttouch = 0;
                    state = 0;
                }    
                else if(button == 28)
                {   
                    if(Func == 1 && Caps == 0)
                    {
                        keypressed = ']';
                    }
                    else if(Caps == 1 && Func == 0)
                    {
                        keypressed = 'J';
                    }
                    else
                    {
                        keypressed = 'j';
                    }
                    a = 0;
                    b = 0;
                    correcttouch = 0;
                    state = 0;
                }    
                else if(button == 29)
                {   
                    if(Func == 1 && Caps == 0)
                    {
                        keypressed = ' ';
                    }
                    else if(Caps == 1 && Func == 0)
                    {
                        keypressed = 'K';
                    }
                    else
                    {
                        keypressed = 'k';
                    }
                    a = 0;
                    b = 0;
                    correcttouch = 0;
                    state = 0;
                }    
                else if(button == 30)
                {   
                    if(Func == 1 && Caps == 0)
                    {
                        keypressed = ' ';
                    }
                    else if(Caps == 1 && Func == 0)
                    {
                        keypressed = 'L';
                    }
                    else
                    {
                        keypressed = 'l';
                    }
                    a = 0;
                    b = 0;
                    correcttouch = 0;
                    state = 0;
                }    
                else if(button == 31)
                {   
                    if(Func == 1 && Caps == 0)
                    {
                        keypressed = ' ';
                    }
                    else
                    {
                        keypressed = ',';
                    }
                    a = 0;
                    b = 0;
                    correcttouch = 0;
                    state = 0;
                }    
                else if(button == 32)
                {   
                    if(Func == 1 && Caps == 0)
                    {
                        keypressed = ' ';
                    }
                    else
                    {
                        keypressed = '!';
                    }
                    a = 0;
                    b = 0;
                    correcttouch = 0;
                    state = 0;
                }    
                else if(button == 33)
                {   
                    if(Func == 1 && Caps == 0)
                    {
                        keypressed = ' ';
                    }
                    else if(Caps == 1 && Func == 0)
                    {
                        keypressed = 'Z';
                    }
                    else
                    {
                        keypressed = 'z';
                    }
                    a = 0;
                    b = 0;
                    correcttouch = 0;
                    state = 0;
                }    
                else if(button == 34)
                {   
                    if(Func == 1 && Caps == 0)
                    {
                        keypressed = ' ';
                    }
                    else if(Caps == 1 && Func == 0)
                    {
                        keypressed = 'X';
                    }
                    else
                    {
                        keypressed = 'x';
                    }
                    a = 0;
                    b = 0;
                    correcttouch = 0;
                    state = 0;
                }    
                else if(button == 35)
                {   
                    if(Func == 1 && Caps == 0)
                    {
                        keypressed = ' ';
                    }
                    else if(Caps == 1 && Func == 0)
                    {
                        keypressed = 'C';
                    }
                    else
                    {
                        keypressed = 'c';
                    }
                    a = 0;
                    b = 0;
                    correcttouch = 0;
                    state = 0;
                }    
                else if(button == 36)
                {   
                    if(Func == 1 && Caps == 0)
                    {
                        keypressed = ' ';
                    }
                    else if(Caps == 1 && Func == 0)
                    {
                        keypressed = 'V';
                    }
                    else
                    {
                        keypressed = 'v';
                    }
                    a = 0;
                    b = 0;
                    correcttouch = 0;
                    state = 0;
                }   
                else if(button == 37)
                {   
                    if(Func == 1 && Caps == 0)
                    {
                        keypressed = ' ';
                    }
                    else if(Caps == 1 && Func == 0)
                    {
                        keypressed = 'B';
                    }
                    else
                    {
                        keypressed = 'b';
                    }
                    a = 0;
                    b = 0;
                    correcttouch = 0;
                    state = 0;
                }   
                else if(button == 38)
                {   
                    if(Func == 1 && Caps == 0)
                    {
                        keypressed = ' ';
                    }
                    else if(Caps == 1 && Func == 0)
                    {
                        keypressed = 'N';
                    }
                    else
                    {
                        keypressed = 'n';
                    }
                    a = 0;
                    b = 0;
                    correcttouch = 0;
                    state = 0;
                }   
                else if(button == 39)
                {   
                    if(Func == 1 && Caps == 0)
                    {
                        keypressed = ' ';
                    }
                    else if(Caps == 1 && Func == 0)
                    {
                        keypressed = 'M';
                    }
                    else
                    {
                        keypressed = 'm';
                    }
                    a = 0;
                    b = 0;
                    correcttouch = 0;
                    state = 0;
                }   
                else if(button == 40)
                {   
                    if(Func == 1 && Caps == 0)
                    {
                        keypressed = ' ';
                    }
                    else
                    {
                        keypressed = '?';
                    }
                    a = 0;
                    b = 0;
                    correcttouch = 0;
                    state = 0;
                }   
                else if(button == 41)
                {   
                    keypressed = ' '; 
                    m++;
                    textx += 12;
                    
                    str[m] =  keypressed; 
                               
                    m -= 1;
                    textx -= 12;
                    
                    str[m] =  keypressed;
                
                    m++;
                    textx += 12;
                    
                    a = 0;
                    b = 0;
                    correcttouch = 0;
                    state = 0;
                }   
                else if(button == 42)
                {   
                    if(Func != 1)
                    {   
                        keypressed = ' ';
                        Caps = !Caps;
                        Func = 0;
                        DrawKeyboard();
                        a = 0;
                        b = 0;
                        correcttouch = 0;
                    }
                    state = 0;
                }  
                else if(button == 43)
                {   
                    keypressed = '.';
                    a = 0;
                    b = 0;
                    correcttouch = 0;
                    state = 0;
                }    
                else if(button == 44)
                {   
                    keypressed = ' ';
                    Func = !Func;
                    Caps = 0;
                    DrawKeyboard();
                    a = 0;
                    b = 0;
                    correcttouch = 0;
                    state = 0;
                }  
                else if(button == 45)
                {   
                    keypressed = ' ';
                    
                    if(m != 0 || textx != 0)
                    {
                        m -= 1;
                        textx -= 12;
                    }
                    
                    a = 0;
                    b = 0;
                    correcttouch = 0;
                    state = 0;
                }       
                else if(button == 46)
                {   
                    keypressed = '\0';
                    Enter = 1;
                    a = 0;
                    b = 0;
                    correcttouch = 0;
                    state = 0;
                }
                else
                {
                    state = 0;    
                }     
                
                str[m] =  keypressed;
                
                lcd.SetTextColor(LCD_COLOR_BLACK);
                lcd.SetBackColor(LCD_COLOR_WHITE);
                lcd.SetFont(&Font20);
                sprintf((char*)text2, "%c", str[m]);
                lcd.DisplayStringAt(0 + textx, LINE(0), (uint8_t *)&text2, LEFT_MODE);
                    
                if(keypressed != ' ')
                {
                    m++;
                    textx += 12;
                }  
                           
                key = 0;
                keypressed = ' ';
                
            }break; 
            case 30:
            {
                if(Keyboard == 1)
                {
                    DrawKeyboard();
                    Keyboard = 0;
                }
                
                if(TS_State.touchDetected == 0)
                {  
                    DrawKeyboard();
                    a = 0;
                    b = 0;
                    correcttouch = 0;
                    state = 0;
                }
            }break;             
        } 
    }
    
    Keyboard = 0;
    Enter = 0;
    m = 0;
    textx = 0;
    state = 0;
    Caps = 0;
    Func = 0;
    lcd.ClearStringLine(0);
    lcd.SetTextColor(Bckclr);
    lcd.FillRect(0, 0, 480, 20);
    lcd.FillRect(KeyboardstartX[0][0],KeyboardstartY[0][0], 415, 187);
    lcd.SetTextColor(Txtclr);
    lcd.SetBackColor(Bckclr);
    lcd.SetFont(FontSize);
}

void F7_TSKeyboard::DrawKeyboard()
{    
    int i, o, stepx = 0, stepy = 0, Drawpointx, Drawpointy;
    uint8_t text[30];
    
    
        char keyboard1[4][10] = {
                                    {'1', '2', '3', '4', '5', '6', '7', '8', '9', '0'},
                                    {'q', 'w', 'e', 'r', 't', 'y', 'u', 'i', 'o', 'p'},
                                    {':', 'a', 's', 'd', 'f', 'g', 'h', 'j', 'k', 'l'},
                                    {',', '!', 'z', 'x', 'c', 'v', 'b', 'n', 'm', '?'}
                                };
    
    
        char keyboard2[4][10] = {
                                    {'1', '2', '3', '4', '5', '6', '7', '8', '9', '0'},
                                    {'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I', 'O', 'P'},
                                    {':', 'A', 'S', 'D', 'F', 'G', 'H', 'J', 'K', 'L'},
                                    {',', '!', 'Z', 'X', 'C', 'V', 'B', 'N', 'M', '?'}
                                };
                                
        char keyboard3[4][10] = {
                                    {'@', '#', '$', '%', 38, '*', '(', ')', '-', '+'},
                                    {'=', '_', '^', ';', '"', '\'', '<', '>', '/', '\\'},
                                    {'\0', '\0', '`', '~', '{', '}', '[', ']', '\0', '\0'},
                                    {'\0', '\0', '\0', '\0', '\0', '\0', '\0', '\0', '\0', '\0'}
                                };
    
    Keyboard = 1;
    
    for(o= 0; o< 10; o++)
    {
        for(i= 0; i < 4; i++)
        {  
            lcd.SetTextColor(LCD_COLOR_WHITE);
             
            lcd.FillRect(Drawpointx = 33 + stepx, Drawpointy  = 75 + stepy, btnsize, btnsize);
            KeyboardstartX[i][o] = Drawpointx;
            KeyboardstartY[i][o] = Drawpointy;
            KeyboardendX[i][o] = Drawpointx + btnsize;
            KeyboardendY[i][o] = Drawpointy + btnsize;
            stepy += 38;
            
            if(Caps == 0 && Func == 0)
            {
                lcd.SetBackColor(LCD_COLOR_WHITE);
                lcd.SetTextColor(LCD_COLOR_BLACK);
                lcd.SetFont(&Font16);
                sprintf((char*)text, "%c", keyboard1[i][o]);
                lcd.DisplayStringAt(Drawpointx+ 13, Drawpointy+ 13, (uint8_t *)&text, LEFT_MODE);
            }
            else if(Caps == 1 && Func == 0)
            {
                lcd.SetBackColor(LCD_COLOR_WHITE);
                lcd.SetTextColor(LCD_COLOR_BLACK);
                lcd.SetFont(&Font16);
                sprintf((char*)text, "%c", keyboard2[i][o]);
                lcd.DisplayStringAt(Drawpointx+ 13, Drawpointy+ 13, (uint8_t *)&text, LEFT_MODE);
            }
            else if(Caps == 0 && Func == 1)
            {
                lcd.SetBackColor(LCD_COLOR_WHITE);
                lcd.SetTextColor(LCD_COLOR_BLACK);
                lcd.SetFont(&Font16);
                sprintf((char*)text, "%c", keyboard3[i][o]);
                lcd.DisplayStringAt(Drawpointx+ 13, Drawpointy+ 13, (uint8_t *)&text, LEFT_MODE);
            }
            
            
            if(stepy > 114)
            {
                stepy = 0;
            }       
        }  
        
        stepx += 38;     
    }
    
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.FillRect(KeyboardstartX[3][2], KeyboardstartY[3][2] + 38, 225, btnsize);
    lcd.FillRect(KeyboardstartX[3][0], KeyboardstartY[3][0] + 38, 73, btnsize);
    lcd.FillRect(KeyboardstartX[3][8], KeyboardstartY[3][8] + 38, btnsize, btnsize);
    lcd.FillRect(KeyboardstartX[3][9], KeyboardstartY[3][9] + 38, 73, btnsize);
    lcd.FillRect(KeyboardstartX[0][9] + 38, KeyboardstartY[0][9], btnsize, 73);
    lcd.FillRect(KeyboardstartX[2][9] + 38, KeyboardstartY[2][9], btnsize, 73);  
    
    lcd.SetBackColor(LCD_COLOR_WHITE);
    lcd.SetTextColor(LCD_COLOR_BLACK);
    lcd.SetFont(&Font16);
    
    sprintf((char*)text, "<");
    lcd.DisplayStringAt(KeyboardstartX[0][9] + 50, KeyboardstartY[0][3] + 35, (uint8_t *)&text, LEFT_MODE);
    lcd.SetFont(&Font12);
    sprintf((char*)text, "E");
    lcd.DisplayStringAt(KeyboardstartX[2][9] + 50, KeyboardstartY[2][9] + 15, (uint8_t *)&text, LEFT_MODE);
    sprintf((char*)text, "N");
    lcd.DisplayStringAt(KeyboardstartX[2][9] + 50, KeyboardstartY[2][9] + 25, (uint8_t *)&text, LEFT_MODE);
    sprintf((char*)text, "T");
    lcd.DisplayStringAt(KeyboardstartX[2][9] + 50, KeyboardstartY[2][9] + 35, (uint8_t *)&text, LEFT_MODE);
    sprintf((char*)text, "E");
    lcd.DisplayStringAt(KeyboardstartX[2][9] + 50, KeyboardstartY[2][9] + 45, (uint8_t *)&text, LEFT_MODE);
    sprintf((char*)text, "R");
    lcd.DisplayStringAt(KeyboardstartX[2][9] + 50, KeyboardstartY[2][9] + 55, (uint8_t *)&text, LEFT_MODE);
    sprintf((char*)text, "CAPS");
    lcd.DisplayStringAt(KeyboardstartX[3][0] + 20, KeyboardstartY[3][0] + 50, (uint8_t *)&text, LEFT_MODE);
    sprintf((char*)text, ".");
    lcd.DisplayStringAt(KeyboardstartX[3][8] + 16, KeyboardstartY[3][8] + 50, (uint8_t *)&text, LEFT_MODE);
    sprintf((char*)text, "FUNC");
    lcd.DisplayStringAt(KeyboardstartX[3][9] + 20, KeyboardstartY[3][9] + 50, (uint8_t *)&text, LEFT_MODE);
    
    lcd.SetTextColor(Txtclr);
    lcd.SetBackColor(Bckclr);
    lcd.SetFont(FontSize);
}       