/* F7 TS Keyboard Library v1.0
 * Copyright (c) 2017 Armand Coetzer
 * s213293048@nmmu.ac.za
 *
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
 
#ifndef F7_TSKeyboard_H
#define F7_TSKeyboard_H
 
#include "mbed.h"
#include "LCD_DISCO_F746NG.h"
#include "TS_DISCO_F746NG.h"

/** Class library for a TS Keyboard, then press enter and the values are stored and the keyboard disappears.
 *
 * Example:
 * @code
 *#include "mbed.h"
 *#include "F7_TSKeyboard.h"

 *F7_TSKeyboard keyboard;
 *LCD_DISCO_F746NG lcd;
 *
 *uint8_t text1[30];
 *char s[100];
 *
 *int main() 
 *{    
 *    lcd.SetFont(&Font12);
 *    lcd.Clear(LCD_COLOR_BLUE);
 *    lcd.SetBackColor(LCD_COLOR_BLUE);
 *    lcd.SetTextColor(LCD_COLOR_WHITE);  
 * 
 *    while(1)
 *    {
 *        keyboard.getkeys(s);
 *        
 *        sprintf((char*)text1, "%s", s);
 *        lcd.DisplayStringAt(0, LINE(3), (uint8_t *)&text1, LEFT_MODE);   
 *         
 *        wait(1);  
 *    }
 *}
 * @endcode
 */
 
 class F7_TSKeyboard 
 {
   
  public:
    /** Constructor. 
    */
    F7_TSKeyboard();
    
    /** Retrieves the keys selected as a string.
    * @param  str[] - stores the keys selected in this array.
    * @retval None.
    */
    void getkeys(char str[]);

  private:
  
    void Detect_isr();
    void DrawKeyboard();
    
    Ticker ticker;
    sFONT *FontSize;
    LCD_DISCO_F746NG lcd;
    TS_DISCO_F746NG ts;
    TS_StateTypeDef TS_State;
        
    uint8_t state, btnsize;
    int OK; 
    uint32_t Bckclr, Txtclr;
    uint8_t correcttouch, button, key, Func, Caps;
    uint16_t frstprsx, frstprsy;
    char keypressed;
    int a, b, recv;
    int Keyboard;
    int KeyboardstartX[4][10];
    int KeyboardstartY[4][10];
    int KeyboardendX[4][10];
    int KeyboardendY[4][10];
    uint8_t status;
    int m, textx, Enter;    
};
 
#endif
