/* Comms Library for communicating with the bluetooth car. v1.0
 * Copyright (c) 2017 Armand Coetzer
 * s213293048@nmmu.ac.za
 *
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
 
#ifndef Comms_H
#define Comms_H
 
#include "mbed.h"
 
/** Class library to create a serial connection from the MCU to the bluetooth device.
 *
 * Example:
 * @code
 * #include "mbed.h"
 *#include "Comms.h"
 *
 *Comms BT(PC_6, PC_7);
 *
 *int main() 
 *{
 *    while(1) 
 *    {   
 *        if(BT.newmsg == true)
 *        {                                  
 *            BT.printf("%s\n",BT.cmd);
 *            BT. printf("%.2f\n", BT.data);
 *            BT.clrmsg();
 *        }
 *        
 *    }
 *}
 * @endcode
 */
 
class Comms : public RawSerial{
  public:
    /** Create a serial connection from the MCU to the bluetooth device. 
    * @param TX Pin for transmitting data.
    * @param RX Pin for Receiving data.
    */
    Comms(PinName TX, PinName RX);
    
   // /** changing the boolen variable to false.
   // * @param 
   // *     None
  //  */
   // void clrmsg();
    
    /** float variable for storing the speed value.
    * @param 
    *     None
    */
    float data;
    
    /** Character string for storing the direction.
    * @param 
    *     None
    */
    char cmd[50];
     
    /** boolean variable to state if there is a new message or not.
    * @param 
    *     None
    */ 
    bool  newmsg;
        

  private:
  
    void commsinterrupt();
    
    char msg[50];          //incoming message string
    int msg_counter;      //character position counter in the message string
    
};
 
#endif
