#include "Comms.h"
#include "mbed.h"
  
Comms::Comms(PinName TX, PinName RX) : RawSerial(TX, RX)
{
  msg_counter = 0;
  newmsg = false;
  
  attach(this, &Comms::commsinterrupt); 
}
 
void Comms::commsinterrupt() 
{    
    char c = getc();                //read the incoming character                   
                            
    if(c == '!')
    {
        msg_counter = 0;
    }
    else if(c == '#')
    {
        msg[msg_counter] = '\0';
        newmsg = true;                          //enable the new message flag to indicate a COMPLETE message was received
        msg_counter = 0;                      //clear the message string
    } 
    else 
    {
        msg[msg_counter] = c;               //add the character to the message string
        msg_counter++;                        //move to the next character in the string
    }  
    
    if(newmsg == true)
    {
        sscanf(msg,"%s %f", &cmd, &data);
        newmsg = false;   
    } 
}

       