#include "mbed.h"
#include "TFT_22_ILI9225.h"
#include "DefaultFonts.h"


const unsigned char str[] =
{
    0x28, 0x06, 0x47, 0x06, 0x20, 0x00, 0x46, 0x06, 0x27, 0x06, 0x45, 0x06, 0x20, 0x00,
    0x2E, 0x06, 0x2F, 0x06, 0x27, 0x06, 0x00
};
char lcd_buf[100];
TFT_22_ILI9225 tft(PB_13, PB_14, PB_15, SPI_MOSI, SPI_SCK, PB_1); // RST,  RS,  CS, SDI (MOSI), CLK (SCK), LED
uint16_t x, y;
bool flag = false;

int main()
{
  
    tft.begin();

    tft.fill(COLOR_BLACK);
    tft.setOrientation(1);
    
    

    tft.setFontColor(COLOR_BLUEVIOLET);
    tft.setFontEffect(2);
    tft.goToXY(0, 16 * 0);

    tft.unicode2ascii((char *)str, lcd_buf);  //  Supporting Persian Language, you can ignore it if you don't use persian
    tft.putMixedEnAndFaString((unsigned char*)lcd_buf, 3);  //  Supporting Persian Language, you can ignore it if you don't use persian
    

    tft.roundRectangle(10, 16 * 4 - 5, tft.maxX() - 10, 16*4 + 40, 20, true, COLOR_LIGHTBLUE);  //  Supporting Persian Language, you can ignore it if you don't use persian
    tft.goToXY(30, 16 * 4);  //  Supporting Persian Language, you can ignore it if you don't use persian
    char *ss = "سلام";//  Supporting Persian Language, you can ignore it if you don't use persian
    tft.putMixedEnAndFaString((unsigned char *)ss, 2);  //  Supporting Persian Language, you can ignore it if you don't use persian


    wait_ms(2000);

    tft.drawRectangle(0, 0, tft.maxX() - 1, tft.maxY() - 1, COLOR_WHITE);
    tft.setFont(Terminal6x8);
    tft.drawText(10, 10, "hello!");
    wait_ms(1000);

    tft.clear();
    tft.drawText(10, 20, "clear");
    wait_ms(1000);

    tft.drawText(10, 30, "text small");
    tft.setBackgroundColor(COLOR_YELLOW);
    tft.setFont(Terminal11x16);
    tft.drawText(90, 30, "BIG", COLOR_RED);
    tft.setBackgroundColor(COLOR_BLACK);
    tft.setFont(Terminal6x8);
    wait_ms(1000);

    tft.drawText(10, 40, "setBacklight off");
    wait_ms(500);
    tft.setBacklight(false);
    wait_ms(500);
    tft.setBacklight(true);
    tft.drawText(10, 50, "setBacklight on");
    wait_ms(1000);

    tft.drawRectangle(10, 10, 110, 110, COLOR_BLUE);
    tft.drawText(10, 60, "rectangle");
    wait_ms(1000);

    tft.fillRectangle(20, 20, 120, 120, COLOR_RED);
    tft.drawText(10, 70, "solidRectangle");
    wait_ms(1000);

    tft.drawCircle(80, 80, 50, COLOR_YELLOW);
    tft.drawText(10, 80, "circle");
    wait_ms(1000);

    tft.fillCircle(90, 90, 30, COLOR_GREEN);
    tft.drawText(10, 90, "solidCircle");
    wait_ms(1000);

    tft.drawLine(0, 0, tft.maxX() - 1, tft.maxY() - 1, COLOR_CYAN);
    tft.drawText(10, 100, "line");
    wait_ms(1000);

    wait_ms(1000);

    for (uint8_t i = 0; i < 4; i++) {
        tft.clear();
        tft.setOrientation(i);
        tft.drawRectangle(0, 0, tft.maxX() - 1, tft.maxY() - 1, COLOR_WHITE);
        tft.drawRectangle(10, 20, 50, 60, COLOR_GREEN);
        tft.drawCircle(70, 80, 10, COLOR_BLUE);
        tft.drawLine(30, 40, 70, 80, COLOR_YELLOW);
        wait_ms(1000);
    }

    tft.setOrientation(0);
    tft.clear();
    tft.setFont(Terminal12x16);
    tft.setBackgroundColor(COLOR_YELLOW);
    tft.drawText(10, 40, "bye!", COLOR_RED);
    tft.setBackgroundColor(COLOR_BLACK);
    tft.setFont(Terminal12x16);
    wait_ms(1000);

    tft.drawText(10, 60, "off");
    wait_ms(1000);

    tft.setBacklight(false);
    tft.setDisplay(false);


    while (true) {
 
    }

 
}