// This program blinks LED using Morse code specification 
// at https://en.wikipedia.org/wiki/Morse_code

#include "mbed.h"

DigitalOut myled(LED1);

// Pauses are in seconds
float SHORT_MORSE=0.2; // Use smaller for speedier output
float WAIT_MORSE=SHORT_MORSE*1; // Morse default is 1x short duration.
float LONG_MORSE=SHORT_MORSE*3; // Morse default is 3x short duration
float WAIT_LETTER=SHORT_MORSE*3; // Morse default is 3x short duration.
float WAIT_SENTENCE=SHORT_MORSE*7; // Morse default is 7x short duration.

// Blinks one to five char morse codes
void blinkMorse(float one, float two, float three, float four, float five) {
        if(one > 0) {
            myled = 1; wait(one); 
        }
        if(two > 0) {
            myled = 0; wait(WAIT_MORSE);
            myled = 1; wait(two);
        }
        if(three > 0) {
            myled = 0; wait(WAIT_MORSE);
            myled = 1; wait(three); 
        }
        if(four > 0) {
            myled = 0; wait(WAIT_MORSE);
            myled = 1; wait(four); 
        }       
        if(five > 0) {
            myled = 0; wait(WAIT_MORSE);
            myled = 1; wait(five); 
        }       
        myled = 0; wait(WAIT_LETTER);
}

void blinkMorse(char letter) {
    switch(letter){
    case 'A': blinkMorse(SHORT_MORSE, LONG_MORSE, 0, 0, 0); break;
    case 'B': blinkMorse(LONG_MORSE, SHORT_MORSE, SHORT_MORSE, SHORT_MORSE, 0); break;
    case 'C': blinkMorse(LONG_MORSE, SHORT_MORSE, LONG_MORSE, SHORT_MORSE, 0); break;
    case 'D': blinkMorse(LONG_MORSE, SHORT_MORSE, SHORT_MORSE, 0, 0); break;
    case 'E': blinkMorse(SHORT_MORSE, 0, 0, 0, 0); break;
    case 'F': blinkMorse(SHORT_MORSE, SHORT_MORSE, LONG_MORSE, SHORT_MORSE, 0); break;
    case 'G': blinkMorse(LONG_MORSE, LONG_MORSE, SHORT_MORSE, 0, 0); break;
    case 'H': blinkMorse(SHORT_MORSE, SHORT_MORSE, SHORT_MORSE, SHORT_MORSE, 0); break;
    case 'I': blinkMorse(SHORT_MORSE, SHORT_MORSE, 0, 0, 0); break;
    case 'J': blinkMorse(SHORT_MORSE, LONG_MORSE, LONG_MORSE, LONG_MORSE, 0); break;
    case 'K': blinkMorse(LONG_MORSE, SHORT_MORSE, LONG_MORSE, SHORT_MORSE, 0); break;
    case 'L': blinkMorse(SHORT_MORSE, LONG_MORSE, SHORT_MORSE, SHORT_MORSE, 0); break;
    case 'M': blinkMorse(LONG_MORSE, LONG_MORSE, 0, 0, 0); break;
    case 'N': blinkMorse(LONG_MORSE, SHORT_MORSE, 0, 0, 0); break;
    case 'O': blinkMorse(LONG_MORSE, LONG_MORSE, LONG_MORSE, 0, 0); break;
    case 'P': blinkMorse(SHORT_MORSE, LONG_MORSE, LONG_MORSE, SHORT_MORSE, 0); break;
    case 'Q': blinkMorse(LONG_MORSE, LONG_MORSE, SHORT_MORSE, LONG_MORSE, 0); break;
    case 'R': blinkMorse(SHORT_MORSE, LONG_MORSE, SHORT_MORSE, 0, 0); break;
        case 'S': blinkMorse(SHORT_MORSE, SHORT_MORSE, SHORT_MORSE, 0, 0); break;
    case 'T': blinkMorse(LONG_MORSE, 0, 0, 0, 0); break;
    case 'U': blinkMorse(SHORT_MORSE, SHORT_MORSE, LONG_MORSE, 0, 0); break;
    case 'V': blinkMorse(SHORT_MORSE, SHORT_MORSE, SHORT_MORSE, LONG_MORSE, 0); break;
    case 'W': blinkMorse(SHORT_MORSE, LONG_MORSE, LONG_MORSE, 0, 0); break;
    case 'X': blinkMorse(LONG_MORSE, SHORT_MORSE, SHORT_MORSE, LONG_MORSE, 0); break;
    case 'Y': blinkMorse(LONG_MORSE, SHORT_MORSE, LONG_MORSE, LONG_MORSE, 0); break;
    case 'Z': blinkMorse(LONG_MORSE, LONG_MORSE, SHORT_MORSE, SHORT_MORSE, 0); break;
    case '0': blinkMorse(LONG_MORSE, LONG_MORSE, LONG_MORSE, LONG_MORSE, LONG_MORSE); break;
    case '1': blinkMorse(SHORT_MORSE, LONG_MORSE, LONG_MORSE, LONG_MORSE, LONG_MORSE); break;
    case '2': blinkMorse(SHORT_MORSE, SHORT_MORSE, LONG_MORSE, LONG_MORSE, LONG_MORSE); break;
    case '3': blinkMorse(SHORT_MORSE, SHORT_MORSE, SHORT_MORSE, LONG_MORSE, LONG_MORSE); break;
    case '4': blinkMorse(SHORT_MORSE, SHORT_MORSE, SHORT_MORSE, SHORT_MORSE, LONG_MORSE); break;
    case '5': blinkMorse(SHORT_MORSE, SHORT_MORSE, SHORT_MORSE, SHORT_MORSE, SHORT_MORSE); break;
    case '6': blinkMorse(LONG_MORSE, SHORT_MORSE, SHORT_MORSE, SHORT_MORSE, SHORT_MORSE); break;
    case '7': blinkMorse(LONG_MORSE, LONG_MORSE, SHORT_MORSE, SHORT_MORSE, SHORT_MORSE); break;
    case '8': blinkMorse(LONG_MORSE, LONG_MORSE, LONG_MORSE, SHORT_MORSE, SHORT_MORSE); break;
    case '9': blinkMorse(LONG_MORSE, LONG_MORSE, LONG_MORSE, LONG_MORSE, SHORT_MORSE); break;
        default: blinkMorse(0, 0, 0, 0, 0); // Space, dot, comma, etc...
    }
}

// Blink Morse Pause: (led off)
void blinkMorsePause() {
    myled = 0; wait(WAIT_SENTENCE);
}

// Blink morse code message ad infinitum
int main() {        
        char myMessage[] = "TEUVO AT VINCIT DOT COM"; 
    while(1) {
            int size=sizeof(myMessage);
            for(int c=0; c<size; c++) {
                blinkMorse(myMessage[c]);
            }
    }
}
