////////////////////////////////////////
//    Rotating Platform Demo Code     //
//  Arkadiraf@gmail.com - 24/05/2017  //
////////////////////////////////////////

/*
   Parts:
    Nucleo STM32F401RE
    X-NUCLEO-IHM01A1 - 3 Stepper motor controller
*/

/*
    Pinout:
    Nucleo STM32F401RE
    PA_5 --> led (DigitalOut)

    PC - Serial 2
    PA_2 (Tx) --> STLINK
    PA_3 (Rx) --> STLINK

    X-NUCLEO-IHM01A1 (http://www.st.com/content/ccc/resource/technical/document/data_brief/59/ff/d0/16/94/ff/49/85/DM00122463.pdf/files/DM00122463.pdf/jcr:content/translations/en.DM00122463.pdf)
    SPI:
    PA_7 (D11) --> mosi
    PA_9 (D12) --> miso
    PA_8 (D13) --> sclk

    Motor 1
    PA_10(D2) --> flag_irq  (DigitalOut)
    PA_9 (D8) --> Standby   (DigitalOut)
    PA_8 (D7) --> MOT1Dir  (DigitalOut)
    PC_7 (D9) --> MOT1Step (PWM)
    PB_6 (D10)--> ssel      (DigitalOut)

    Motor 2
    PA_10(D2) --> flag_irq  (DigitalOut)
    PA_9 (D8) --> Standby   (DigitalOut)
    PB_5 (D4) --> MOT2Dir   (DigitalOut)
    PB_3 (D3) --> MOT2Step  (PWM)
    PB_6 (D10)--> ssel      (DigitalOut)

    Motor 3
    PA_10(D2) --> flag_irq  (DigitalOut)
    PA_9 (D8) --> Standby   (DigitalOut)
    PB_4 (D5) --> MOT3Dir   (DigitalOut)
    PB_10(D6) --> MOT3Step  (PWM)
    PB_6 (D10)--> ssel      (DigitalOut)


*/

/* Includes ------------------------------------------------------------------*/

/* mbed specific header files. */
#include "mbed.h"

/* Helper header files. */
#include "DevSPI.h"

/* Component specific header files. */
#include "l6474_class.h"


/* Definitions ---------------------------------------------------------------*/

/* Number of steps to move. */
#define STEPS 3200


/* Variables -----------------------------------------------------------------*/

/* Motor Control Component. */
L6474 *motor1;
L6474 *motor2;
L6474 *motor3;

/* Main ----------------------------------------------------------------------*/

int main()
{
    /*----- Initialization. -----*/

    /* Initializing SPI bus. */
    DevSPI dev_spi(D11, D12, D13);

    /* Initializing Motor Control Components. */
    motor1 = new L6474(D2, D8, D7, D9, D10, dev_spi);
    motor2 = new L6474(D2, D8, D4, D3, D10, dev_spi);
    motor3 = new L6474(D2, D8, D5, D6, D10, dev_spi);
    if (motor1->Init() != COMPONENT_OK)
        exit(EXIT_FAILURE);
    if (motor2->Init() != COMPONENT_OK)
        exit(EXIT_FAILURE);
    if (motor3->Init() != COMPONENT_OK)
        exit(EXIT_FAILURE);



    /*----- Changing motor setting. -----*/
    
    /* Setting High Impedance State to update L6474's registers. */
    motor1->SoftHiZ();
    motor2->SoftHiZ();
    motor3->SoftHiZ();
    // Disabling motor
    motor1->Disable();
    motor2->Disable();
    motor3->Disable();
    /* Changing step mode. */
    motor1->SetStepMode(STEP_MODE_1_16);
    motor2->SetStepMode(STEP_MODE_1_16);
    motor3->SetStepMode(STEP_MODE_1_16);
   
    /* Increasing the torque regulation current. */
    motor1->SetParameter(L6474_TVAL, 1250); // Limit 2.0A
    motor2->SetParameter(L6474_TVAL, 1650); // Limit 1.7A
    motor3->SetParameter(L6474_TVAL, 300);  // Limit 0.28A
    
    /* Max speed to 2400 step/s. */
    motor1->SetMaxSpeed(750);
    motor2->SetMaxSpeed(750);
    motor3->SetMaxSpeed(750);

    /* Min speed to 200 step/s. */
    motor1->SetMinSpeed(100);
    motor2->SetMinSpeed(100);
    motor3->SetMinSpeed(100);
    
    /* set accelerations */
    motor1->SetAcceleration(250);
    motor2->SetAcceleration(250);
    motor3->SetAcceleration(250);
    motor1->SetDeceleration(250);
    motor2->SetDeceleration(250);
    motor3->SetDeceleration(250);
    
    // Enabling motor
    motor1->Enable();
    motor2->Enable();
    motor3->Enable();
    

    /* Printing to the console. */
    printf("Motor Control Application Example for 3 Motors\r\n\n");

    /*----- Moving. -----*/
    
    /* Moving N steps in the forward direction. */
    motor1->Move(StepperMotor::FWD, STEPS);
    motor2->Move(StepperMotor::FWD, STEPS);
    motor3->Move(StepperMotor::FWD, STEPS);
    /* Waiting while the motor is active. */
    motor1->WaitWhileActive();
    motor2->WaitWhileActive();
    motor3->WaitWhileActive();
 
     /* Waiting 2 seconds. */
    wait_ms(2000);
 
    
    /* Moving N steps in the backward direction. */
    motor1->Move(StepperMotor::BWD, STEPS);
    motor2->Move(StepperMotor::BWD, STEPS);
    motor3->Move(StepperMotor::BWD, STEPS);
    /* Waiting while the motor is active. */
    motor1->WaitWhileActive();
    motor2->WaitWhileActive();
    motor3->WaitWhileActive();
    
    /* Waiting 2 seconds. */
    wait_ms(2000);

    /* Infinite Loop. */
    while(1)
    {
            /*----- Moving. -----*/
    
    /* Moving N steps in the forward direction. */
    motor1->Move(StepperMotor::FWD, STEPS);
    motor2->Move(StepperMotor::FWD, STEPS);
    motor3->Move(StepperMotor::FWD, STEPS);
    /* Waiting while the motor is active. */
    motor1->WaitWhileActive();
    motor2->WaitWhileActive();
    motor3->WaitWhileActive();
    
    /* Moving N steps in the backward direction. */
    motor1->Move(StepperMotor::BWD, STEPS);
    motor2->Move(StepperMotor::BWD, STEPS);
    motor3->Move(StepperMotor::BWD, STEPS);
    /* Waiting while the motor is active. */
    motor1->WaitWhileActive();
    motor2->WaitWhileActive();
    motor3->WaitWhileActive();
    
    /* Waiting 2 seconds. */
    wait_ms(2000);
    }
}
