////////////////////////
// ADC Init functions //
////////////////////////

/* ADC1 init function */
void ADC1_Init(void)
{

    ADC_ChannelConfTypeDef sConfig;

    // Common config
    hadc1.Instance = ADC1; //
    hadc1.Init.ClockPrescaler = ADC_CLOCK_SYNC_PCLK_DIV4; // ADC_CLOCK_SYNC_PCLK_DIV2 - div2 is above physical recomendetion, div4 is about 1.25 mhz
    hadc1.Init.Resolution = ADC_RESOLUTION12b; //
    hadc1.Init.DataAlign = ADC_DATAALIGN_RIGHT; //
    hadc1.Init.ScanConvMode = DISABLE; //
    hadc1.Init.EOCSelection = DISABLE; //
    hadc1.Init.ContinuousConvMode = ENABLE; //
    hadc1.Init.DMAContinuousRequests = ENABLE; //
    hadc1.Init.NbrOfConversion = 1; //
    hadc1.Init.DiscontinuousConvMode = DISABLE; //
    hadc1.Init.NbrOfDiscConversion = 0; //
    hadc1.Init.ExternalTrigConv = ADC_EXTERNALTRIGCONV_T1_CC1; //
    hadc1.Init.ExternalTrigConvEdge = ADC_EXTERNALTRIGCONVEDGE_NONE; //
    if (HAL_ADC_Init(&hadc1) != HAL_OK) {
        printf("!!! Error in ADC initialization !!!\n");
    }

    // Configure Regular Channel
    sConfig.Channel = ADC_CHANNEL_0;
    sConfig.Rank = 1;
    //sConfig.SingleDiff = ADC_SINGLE_ENDED;
    sConfig.SamplingTime = ADC_SAMPLETIME_3CYCLES;
    sConfig.Offset = 0;
    if (HAL_ADC_ConfigChannel(&hadc1, &sConfig) != HAL_OK) {
        printf("!!! Error in ADC channel initialization !!!\n");
    }
}

/* DAC1 init function */
void DAC1_Init(void)
{

    DAC_ChannelConfTypeDef sConfig;

    // DAC Initialization
    hdac1.Instance = DAC;
    if(HAL_DAC_Init(&hdac1) != HAL_OK) {
        printf("!!! Error in DAC initialization !!!\n");
    }

    // DAC channel OUT1 config
    sConfig.DAC_Trigger = DAC_TRIGGER_NONE;
    sConfig.DAC_OutputBuffer = DAC_OUTPUTBUFFER_ENABLE;
    if (HAL_DAC_ConfigChannel(&hdac1, &sConfig, DAC_CHANNEL_1) != HAL_OK) {
        printf("!!! Error in DAC channel initialization !!!\n");
    }
}
