#include <ctype.h>
#include "mbed.h"
#include "SPI_MX25R.h"
DigitalOut led_green(D5);
DigitalOut led_red(D4);
 
// SPI_MX25R(PinName mosi, PinName miso, PinName sclk, PinName cs) ;
// STM32L476
// D13 SPI0_SCK
// D12 SPI0_MISO
// D11 SPI0_MOSI
// D10 SPI0_PCS0
//          Vdd =3.3V 
//          Gnd =0.0V 
SPI_MX25R spi_mem(D11, D12, D13,D10) ;

uint8_t * mem_nBytes;
 
void rdRange(unsigned long rd_start_address, unsigned long rd_end_address)
{
    unsigned int i, j ;
    unsigned char data[0x10] ;
    unsigned long current_address = rd_start_address ;
    printf("\n\r") ;
    printf("rd_start_address = 0x%08X\n\r", rd_start_address) ;  
    printf("rd_end_address   = 0x%08X\n\r", rd_end_address) ;  
    printf("\n\r") ;
    printf("         ") ;             // print header +0 to +F
    for (i = 0 ; i < 0x10 ; i++ ) {
        printf("+%X ",i) ;
    }
    printf("\n\r") ;
    printf("         -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --") ;             
    printf("\n\r") ;
        for (i = rd_start_address ; current_address < rd_end_address ; i++ ) {
        printf("%06X : ", current_address ) ;   // print start address :
        for (j = 0 ; j <= 15 ; j++ ) {
            data[j] = spi_mem.read8(current_address ) ;
            printf("%02X ", data[j]) ;
            current_address = current_address + 0x01 ;
        }
        printf(": ") ;
        for (i = 0 ; i < 0x10 ; i++ ) {
            if (isprint(data[i])) {
                printf("%c", data[i]) ;
            } else {
                printf(".") ;
            }
        }
        printf(" :\n\r") ;
    }
    printf("\n\r") ;
}  
 
void rdSFDPRange(unsigned long rd_start_address, unsigned long rd_end_address)
{
    unsigned int i, j ;
    unsigned char data[0x10] ;
    unsigned long current_address = rd_start_address ;
    printf("\n\r") ;
    printf("rd_start_address = 0x%08X\n\r", rd_start_address) ;  
    printf("rd_end_address   = 0x%08X\n\r", rd_end_address) ;  
    printf("\n\r") ;
    printf("         ") ;             // print header +0 to +F
    for (i = 0 ; i < 0x10 ; i++ ) {
        printf("+%X ",i) ;
    }
    printf("\n\r") ;
    printf("         -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --") ;             
    printf("\n\r") ;
        for (i = rd_start_address ; current_address < rd_end_address ; i++ ) {
        printf("%06X : ", current_address ) ;   // print start address :
        for (j = 0 ; j <= 15 ; j++ ) {
            data[j] = spi_mem.readSFDP(current_address ) ;
            printf("%02X ", data[j]) ;
            current_address = current_address + 0x01 ;
        }
        printf(": ") ;
        for (i = 0 ; i < 0x10 ; i++ ) {
            if (isprint(data[i])) {
                printf("%c", data[i]) ;
            } else {
                printf(".") ;
            }
        }
        printf(" :\n\r") ;
    }
    printf("\n\r") ;
} 
 
void rdFREADRange(unsigned long rd_start_address, unsigned long rd_end_address)
{
    unsigned int i, j ;
    unsigned char data[0x10] ;
    unsigned long current_address = rd_start_address ;
    printf("\n\r") ;
    printf("rd_start_address = 0x%08X\n\r", rd_start_address) ;  
    printf("rd_end_address   = 0x%08X\n\r", rd_end_address) ;  
    printf("\n\r") ;
    printf("         ") ;             // print header +0 to +F
    for (i = 0 ; i < 0x10 ; i++ ) {
        printf("+%X ",i) ;
    }
    printf("\n\r") ;
    printf("         -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --") ;             
    printf("\n\r") ;
        for (i = rd_start_address ; current_address < rd_end_address ; i++ ) {
        printf("%06X : ", current_address ) ;   // print start address :
        for (j = 0 ; j <= 15 ; j++ ) {
            data[j] = spi_mem.readFREAD(current_address ) ;
            printf("%02X ", data[j]) ;
            current_address = current_address + 0x01 ;
        }
        printf(": ") ;
        for (i = 0 ; i < 0x10 ; i++ ) {
            if (isprint(data[i])) {
                printf("%c", data[i]) ;
            } else {
                printf(".") ;
            }
        }
        printf(" :\n\r") ;
    }
    printf("\n\r") ;
} 
 
void commandMenu(void)  // TeraTerm Display (Enable Terminal Local Echo On).
{
    printf("== Commands =========== (Comments) ===============================================\n\r") ;
    printf("\n\r") ;
    printf("  wren                  (Write Enable,  set WEL=1, 06h)\n\r") ;
    printf("  wrdi                  (Write Disable, set WEL=0, 04h)\n\r") ;
    printf("  rdid                  (Read Manu & JEDEC Dev ID, 9Fh)\n\r") ;
    printf("  rems                  (Read Elect. Manu & Dev ID,90h)\n\r") ;
    printf("  res                   (Read Elect. Signiture,    ABh)\n\r") ;
    printf("  rdsr                  (Read Status Register,     05h)\n\r") ;
    printf("  rdcr                  (Read Config Register,     15h)\n\r") ;
    printf("  rdscr                 (Read Security Register,   2Bh)\n\r") ;
    printf("  enso                  (Enter Secure OTP Area,    B1h)\n\r") ;
    printf("  exso                  (Exit Secure OTP Area,     C1h)\n\r") ;
    printf("  reset                 (ResetEnable + SoftwareReset = 66h + 99h)\n\r") ;
    printf("  hp                    (Enter HP mode = WREN=06h + WRSR= 01h 000002h)\n\r") ;
    printf("  lp                    (Enter LP mode = WREN=06h + WRSR= 01h 000000h)\n\r") ;
    printf("  wrsr  data_3B         (Write SR 01h +3B data,ex: wrsr 000002h, set wren 1st)\n\r") ;
    printf("  wrscr data_1B         (Write Security Reg 2Fh +1B data, caution LDSO bit OTP!)\n\r") ;
    printf("  se    address         (4KB Sector Erase,     ex: se 0x00    <- note: sets WEL)\n\r") ;
    printf("  be    address         (64KB Block Erase,     ex: be 0x00    <- note: sets WEL)\n\r") ;
    printf("  32Kbe address         (32KB Block Erase,     ex: 32kbe 0x00 <- note: sets WEL)\n\r") ;
    printf("  ce                    (Chip Erase = C7h,     ex: ce         <- note: sets WEL)\n\r") ;
    printf("  pp    address         (256B Page Program,    ex: pp 0x00    <- note: sets WEL)\n\r") ;
    printf("  pread    address         (256B Page Read,       ex: pr 0x000000 \n\r") ;
    printf("  nread    address         (nBytes Read,          ex: pn 0x00 \n\r 0x100 \n\r") ;    
    printf("  read  address         (read 1 byte of data,  ex: read 0x0000)\n\r") ;
    printf("  rd1   startadr endadr (read range of data,   ex: rd1  0x00 0x10)\n\r") ;
    printf("  fread startadr endadr (read range of data,   ex: sfdp 0x00 0x10)\n\r") ;
    printf("  sfdp  startadr endadr (read range of SFDP,   ex: sfdp 0x00 0x10)\n\r") ;
    printf("==================================================================================\n\r") ;
    printf("\n\r") ;
}
 
int main() {
    char cmd[32] ;
    int i ;
    int numData = 256 ;
    unsigned long address = 0 ;
    unsigned long rd_start_address = 0 ;
    unsigned long rd_end_address = 0 ;
    unsigned char data[256] ;
    
   extern serial_t stdio_uart ;
   serial_baud(&stdio_uart, 9600) ;
    
    printf("\n\r") ;
    printf("\n\r") ;
    printf("\n\r") ;
    printf("\n\r") ;
printf("\n\r               ####################################################\n\r") ;
    printf("               #                                                  #\n\r") ;
    printf("               #  Macronix MX25Rxx35F Serial NOR Flash Testbench  #\n\r") ;
    printf("               #                                                  #\n\r") ;
    printf("               ####################################################\n\r") ;
    printf("\n\r") ;
    printf("\n\r") ;
    commandMenu() ;
    
led_green = 0;
led_red = 1;
    
while(1){
        printf("Enter command from list, or type menu.\n\r") ;
        printf("> ") ;
        scanf("%s", cmd) ;
        
        if (strcmp(cmd, "read") == 0) {         // Read Byte
            scanf("%X", &address) ;
            data[0] = spi_mem.read8(address) ;
            printf("%01X : 0x%02X\n\r", address, data[0]) ;
              
        } else if (strcmp(cmd, "rd1") == 0) {   // Read Range
            scanf("%X", &rd_start_address) ;
            scanf("%X", &rd_end_address) ;
            rdRange(rd_start_address, rd_end_address) ;
            
        } else if (strcmp(cmd, "rdsr") == 0) {  // Read Status Register
            data[0] = spi_mem.readStatus() ;
            printf("                               status register = 0x%02X\n\r", data[0]) ;            
            printf("RDSR = 05h done\n\r") ;
            
        } else if (strcmp(cmd, "rdscr") == 0) {  // Read Security Register
            data[0] = spi_mem.readSecurity() ;
            printf("                               security register = 0x%02X\n\r", data[0]) ;            
            printf("RDSR = 05h done\n\r") ;
              
        } else if (strcmp(cmd, "reset") == 0) { // ResetEnable + Software Reset 
            spi_mem.resetEnable() ;
            spi_mem.reset() ;       
            printf("Software ResestEnable 66h + Reset 99h completed\n\r") ;
              
        } else if (strcmp(cmd, "rdcr") == 0) { // Read Configuration Register
            printf("                               configuration register = 0x%04X\n\r", spi_mem.readConfig()) ;           
            printf("RDCR = 15h done\n\r") ;
              
        } else if (strcmp(cmd, "rdid") == 0) { // Read Manufacturer and JEDEC Device ID
            printf("                               ID = 0x%06X\n\r", spi_mem.readID()) ;
            printf("RDID = 9Fh done\n\r") ;
            
        } else if (strcmp(cmd, "rems") == 0) { // Read Electronic Munufacturer and Device ID
            printf("                               ID = 0x%04X\n\r", spi_mem.readREMS()) ;
            printf("REMS = 90h done\n\r") ;
              
        } else if (strcmp(cmd, "res") == 0) {  // Read Electronic Signiture
            data[0] = spi_mem.readRES() ;
            printf("                               Electronic Signiture = 0x%02X\n\r", data[0]) ;            
            printf("RES = ABh done\n\r") ;
            
        } else if (strcmp(cmd, "wren") == 0) { // Write Enable
            spi_mem.writeEnable() ;
            printf("                               WREN = 06h set\n\r") ;
              
        } else if (strcmp(cmd, "wrdi") == 0) { // Write Disable
            spi_mem.writeDisable() ;
            printf("                               done\n\r") ;
            
        } else if (strcmp(cmd, "enso") == 0) { // Enter Secure OTP Area
            spi_mem.enterSecureOTP() ;
            printf("                               Entered Secure OTP Area\n\r") ;
          
        } else if (strcmp(cmd, "exso") == 0) { // Exit Secure OTP Area
            spi_mem.exitSecureOTP() ;
            printf("                               Entered Secure OTP Area\n\r") ;  
            
        } else if (strcmp(cmd, "pp") == 0)   { // Page Program
            scanf("%X", &address) ;
            printf("writing %d bytes to 0x%X\n\r",numData, address) ;
            spi_mem.writeEnable() ; // send WREN 1st
            for (i = 0 ; i < numData ; i++ ) {
                data[i] = i & 0xFF ;
            }
            spi_mem.programPage(address, data, numData) ;
            data[0] = 0 ;
            while((data[0] & 0x01) != 0x01 ) {
                printf(".") ;
                data[0] = spi_mem.readStatus() ;
                wait(0.01) ;
            }
            printf("\n\r") ;
            printf("                               PP = 02h done\n\r") ;
           
        }else if (strcmp(cmd, "pread") == 0)   { // Page read
            scanf("%X", &address) ;
            printf("reading page at: 0x%X\n\r",address) ;
            uint8_t pageData[256]={0};
            spi_mem.readNBytes(address, pageData, 256) ;
            printf("\n\r________Start________\n\r") ;
            for ( int jj = 0 ; jj < 256 ; jj++ ) {
                printf("%02X ", pageData[jj]) ;
            }
            printf("\n\r________Done__________\n\r") ;  
            
        }else if (strcmp(cmd, "nread") == 0)   { // nBytes read
            scanf("%X", &address) ;
            int nBytes=0;
            scanf("%d", &nBytes) ;
            printf("reading %d bytes at: 0x%X \n\r",nBytes, address) ;
            mem_nBytes = new uint8_t [nBytes]; 
            spi_mem.readNBytes(address, mem_nBytes, nBytes) ;
            printf("\n\r________Start________\n\r") ;
            for ( int jj = 0 ; jj < nBytes ; jj++ ) {
                printf("%02X ", mem_nBytes[jj]) ;
            }
            printf("\n\r________Done__________\n\r") ;  
            
        } else if (strcmp(cmd, "ce") == 0) {    // Chip Erase
            spi_mem.writeEnable() ; // send WREN 1st
            spi_mem.chipErase() ;
            data[0] = 0x01 ;           // poll if WIP bit SR<0>=1
            while((data[0] & 0x01) != 0 ) {
                printf("wait, chip erase in progress") ;
                data[0] = spi_mem.readStatus() ;
                printf("             -->           status register = 0x%02X\n\r", data[0]) ;   
                wait(5) ;
                 }                  // end poll
            printf("CE = C7h done\n\r") ;
              
        } else if (strcmp(cmd, "se") == 0) {    // Sector Erase
            scanf("%X", &address) ;
             printf("Eraseing address 0x%X\n\r", address) ;
            spi_mem.writeEnable() ; // send WREN 1st
            spi_mem.sectorErase(address) ;
            data[0] = 0x01 ;           // poll if WIP bit SR<0>=1
            while((data[0] & 0x01) != 0 ) {
                printf(".") ;
                data[0] = spi_mem.readStatus() ;
                wait(0.1) ;
                 }                  // end poll
            printf("SE = 20h done\n\r") ;
               
        } else if (strcmp(cmd, "be") == 0) {    // 64KB Block Erase
            scanf("%X", &address) ;
             printf("Eraseing address 0x%X\n\r", address) ;
            spi_mem.writeEnable() ; // send WREN 1st
            spi_mem.blockErase(address) ;
            data[0] = 0x01 ;           // poll if WIP bit SR<0>=1
            while((data[0] & 0x01) != 0 ) {
                printf(".") ;
                data[0] = spi_mem.readStatus() ;
                wait(0.1) ;
                 }                  // end poll
            printf("BE = D8h done\n\r") ;
              
        } else if (strcmp(cmd, "32kbe") == 0) {    // 32KB Block Erase
            scanf("%X", &address) ;
             printf("Eraseing address 0x%X\n\r", address) ;
            spi_mem.writeEnable() ; // send WREN 1st
            spi_mem.blockErase(address) ;
            data[0] = 0x01 ;           // poll if WIP bit SR<0>=1
            while((data[0] & 0x01) != 0 ) {
                printf(".") ;
                data[0] = spi_mem.readStatus() ;
                wait(0.1) ;
                 }                  // end poll
            printf("32KBE = 52h done\n\r") ;
              
        } else if (strcmp(cmd, "wrsr") == 0) {    // Write to Status and Configuration Reg 1 and 2
            scanf("%X", &address) ;
            spi_mem.writeStatusreg(address) ; // Write SR cmd 01h +SRdata 00h +CR1data 00h +CR2data 02h, (CR2<1> = 1 to Enter HP Mode)
             wait(0.5) ;
            printf("                               You wrote 0x%X to Staus and Config Register 1 and 2 \n\r", address) ;
            
        } else if (strcmp(cmd, "wrscr") == 0) { // Write to Security Reg
            scanf("%X", &address) ;
            spi_mem.writeSecurityreg(address) ; // WRSCUR cmd 2Fh + 1B of data
             wait(0.5) ;
            printf("                               You wrote 0x%X to Security Register \n\r", address) ;
              
        } else if (strcmp(cmd, "hp") == 0) {    // Enter High Performance Mode
            spi_mem.writeEnable() ; // send WREN 1st
            spi_mem.writeStatusreg(0x000002) ; // Write SR cmd 01h +SRdata 00h +CR1data 00h +CR2data 02h, (CR2<1> = 1 to Ernter HP Mode)
            printf("                               You are now in High Performance mode (Red LED on)\n\r") ;
                led_red = 0;
                led_green = 1;
              
        } else if (strcmp(cmd, "lp") == 0) {    // Enter Low Power Mode
            spi_mem.writeEnable() ; // send WREN 1st
            spi_mem.writeStatusreg(0x000000) ; // Write SR cmd 01h +SRdata 00h +CR1data 00h +CR2data 00h, (CR2<1> = 0 to Ernter LP Mode)
            printf("                               You are now in Low Power mode (Green LED on)\n\r") ;
                led_green = 0;
                led_red = 1;
            
        } else if (strcmp(cmd, "fread") == 0) {  // Read SFDP Range
            scanf("%X", &rd_start_address) ;
            scanf("%X", &rd_end_address) ;
            rdFREADRange(rd_start_address, rd_end_address) ;     
            
        } else if (strcmp(cmd, "sfdp") == 0) {  // Read SFDP Range
            scanf("%X", &rd_start_address) ;
            scanf("%X", &rd_end_address) ;
            rdSFDPRange(rd_start_address, rd_end_address) ;
            
        } else if (strcmp(cmd, "help") == 0) {
            commandMenu() ;
        } else if (strcmp(cmd, "menu") == 0) {
            commandMenu() ; 
        } else {
            printf("Command NOT Recognized [ %s ]\n\r", cmd) ;
            commandMenu() ;
        }
    }
}