#include "imu_driver.hpp"

#if defined(COMPILE_TEST)

SPI spi2(PB_15, PB_14, PB_13); //1Mbps default, MOSI MISO SCLK, for IMU
Serial  pc(USBTX, USBRX, 115200);   // print debug message

inline void test_exti_rcv_normal_msg()
{
    ImuDriver<spi2, PC_4, PB_2, PB_1> imu(ImuExtiRcvNormalMsg); //SPI instance, reset, data ready, slave select

    while(true) {
        wait_ms(1);
        pc.printf("gyro: % .3f, % .3f, % .3f, accel: % .3f, % .3f, % .3f\n\r", 
                    imu.imuProcessedData.rate[0], imu.imuProcessedData.rate[1], imu.imuProcessedData.rate[2], 
                    imu.imuProcessedData.accel[0], imu.imuProcessedData.accel[1], imu.imuProcessedData.accel[2]);
    }
}

inline void test_exti_rcv_ahrs_msg()
{
    ImuDriver<spi2, PC_4, PB_2, PB_1> imu(ImuExtiRcvAhrsMsg); //SPI instance, reset, data ready, slave select

    while(true) {
        wait_ms(1);
        pc.printf("PRY: % .3f, % .3f, % .3f\n\r", imu.ahrsProcessedData.attitude[0], imu.ahrsProcessedData.attitude[1], imu.ahrsProcessedData.attitude[2]);
    }
}

inline void test_exti_rcv_both_msg()
{
    ImuDriver<spi2, PC_4, PB_2, PB_1> imu(ImuExtiRcvBothMsg); //SPI instance, reset, data ready, slave select

    while(true) {
        wait_ms(1);
        pc.printf("PRY: % .3f, % .3f, % .3f\n\r", imu.ahrsProcessedData.attitude[0], imu.ahrsProcessedData.attitude[1], imu.ahrsProcessedData.attitude[2]);
        pc.printf("gyro: % .3f, % .3f, % .3f, accel: % .3f, % .3f, % .3f\n\r", 
                    imu.imuProcessedData.rate[0], imu.imuProcessedData.rate[1], imu.imuProcessedData.rate[2], 
                    imu.imuProcessedData.accel[0], imu.imuProcessedData.accel[1], imu.imuProcessedData.accel[2]);
    }
}

#endif  // COMPILE_TEST