/*
 * (C) Copyright 2015 Valentin Ivanov. All rights reserved.
 *
 * This file is part of the RetroPlatform Library
 *
 * The RetroPlatform Library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>
 *
 * This library is inspired by Gamebuino Library (http://gamebuino.com)
 * from Aurélien Rodot. 
 */
#include "mbed.h"
#include "Display.h"

Display::Display( PinName backlightPin, PinName resetPin, PinName dsPin,
                  PinName mosiPin, PinName misoPin, PinName clkPin, PinName csPin, PanelColorFilter colorFilter )
    : LCD_ST7735(backlightPin, resetPin, dsPin, mosiPin, misoPin, clkPin, csPin, colorFilter )
{
}


void Display::drawBitmapIndexed(uint8_t x, uint8_t y, const uint8_t *pbmp)
{
    drawBitmapIndexed(x, y, pbmp[0], pbmp[1],  pbmp+2);
}

void Display::drawBitmapIndexed(uint8_t x, uint8_t y, uint8_t w, uint8_t h,  const uint8_t *pbmp)
{
    clip(x, y, w, h);
    int bytes = w * h / 8;
    beginBatchCommand(CMD_RAMWR);

    while(bytes--) {
//        writeBatchData(_pPalette[*pbmp>>7&0x1]);
//        writeBatchData(_pPalette[*pbmp>>6&0x1]);
//        writeBatchData(_pPalette[*pbmp>>5&0x1]);
//        writeBatchData(_pPalette[*pbmp>>4&0x1]);
//        writeBatchData(_pPalette[*pbmp>>3&0x1]);
//        writeBatchData(_pPalette[*pbmp>>2&0x1]);
//        writeBatchData(_pPalette[*pbmp>>1&0x1]);
//        writeBatchData(_pPalette[(*pbmp++)&0x1]);
    }
    endBatchCommand();
}

void Display::drawBitmapIndexed(uint8_t x, uint8_t y, uint8_t w, uint8_t h,  const uint8_t *pbmp, const uint16_t *palette, bool mirrored)
{
    clip(x, y, w, h);
    int pixels = w * h;
    beginBatchCommand(CMD_RAMWR);

    if( mirrored ) {
        for( int iy =0; iy < h; iy++ ) {
            const uint8_t * p  = pbmp + (w>>1)*iy + (w>>1)-1;
            for( int ix =0; ix < w; ) {
                writeBatchData(palette[(*p)&0x0F]);
                writeBatchData(palette[((*p)>>4)&0x0F]);
                ix+=2;
                p--;
            }
        }
    } else {
        while(pixels) {
            writeBatchData(palette[((*pbmp)>>4)&0x0F]);
            writeBatchData(palette[(*pbmp)&0x0F]);
            pixels-=2;
            pbmp++;
        }
    }
    endBatchCommand();
}

//void Display::drawBitmapTransparent(uint8_t x, uint8_t y, uint8_t w, uint8_t h,  const uint8_t *pbmp, const uint16_t *palette, uint8_t color, bool mirrored )
//{
//    clip(x, y, w, h);
//    int pixels = w * h;
//    beginBatchCommand(CMD_RAMWR);
//
//    if( mirrored ) {
//        for( int iy =0; iy < h; iy++ ) {
//            const uint8_t * p  = pbmp + w*iy + w-1;
//            for( int ix =0; ix < w; ix++ ) {
//            {
//                writeBatchData(palette[*p--]);
//             }
//            }
//        }
//    } else {
//        while(pixels--) {
//            writeBatchData(palette[*pbmp++]);
//        }
//    }
//    endBatchCommand();
//}

void Display::drawBitmapIndexed(uint8_t x, uint8_t y, int w, int h, int src_x, int src_y, int srcWidth, int srcHeight, const uint8_t *pbmp, const uint16_t *palette)
{
    clip(x, y, srcWidth, srcHeight);
    beginBatchCommand(CMD_RAMWR);
    const uint8_t *p = pbmp + src_x + (src_y * w);
    for(int iy = 0; iy < srcHeight; ++iy) {
        for(int ix = 0; ix < srcWidth; ++ix) {
            writeBatchData(palette[*(p + ix)]);
        }
        p += w;
    }
    endBatchCommand();
}

void Display::eraseBitmapIndexed(uint8_t x, uint8_t y, const uint8_t *pbmp)
{
    eraseBitmapIndexed(x, y, pbmp[0], pbmp[1],  pbmp+2);
}

void Display::eraseBitmapIndexed(uint8_t x, uint8_t y, uint8_t w, uint8_t h,  const uint8_t *pbmp)
{
    clip(x, y, w, h);
    int bytes = w * h / 8;
    beginBatchCommand(CMD_RAMWR);

    while(bytes--) {
//        writeBatchData(_pPalette[0]);
//        writeBatchData(_pPalette[0]);
//        writeBatchData(_pPalette[0]);
//        writeBatchData(_pPalette[0]);
//        writeBatchData(_pPalette[0]);
//        writeBatchData(_pPalette[0]);
//        writeBatchData(_pPalette[0]);
//        writeBatchData(_pPalette[0]);
    }
    endBatchCommand();
}