/*
 * (C) Copyright 2015 Valentin Ivanov. All rights reserved.
 *
 * This file is part of the RetroPlatform Library
 *
 * The RetroPlatform Library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>
 *
 * This library is inspired by Gamebuino Library (http://gamebuino.com)
 * from Aurélien Rodot. 
 */
#ifndef __UTILS_H__
#define __UTILS_H__

uint8_t constrain(uint8_t val, uint8_t minimum, uint8_t maximum );
uint8_t max(uint8_t val1, uint8_t val2 );
uint8_t min(uint8_t val1, uint8_t val2 );

int write_eeprom( char *source_addr, char *target_addr, int size );
int read_eeprom( char *source_addr, char *target_addr, int size );

#endif  //__UTILS_H__