/*
 * (C) Copyright 2015 Valentin Ivanov. All rights reserved.
 *
 * This file is part of the RetroPlatform Library
 *
 * The RetroPlatform Library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>
 *
 * This library is inspired by Gamebuino Library (http://gamebuino.com)
 * from Aurélien Rodot. 
 */
#ifndef __RETRO_H__
#define __RETRO_H__

#include "mbed.h"
#include "Sound.h"
#include "Display.h"
#include "Color565.h"

#define LCDWIDTH    160
#define LCDHEIGHT   128

#define BTN_LEFT    0
#define BTN_RIGHT   1
#define BTN_DOWN    2
#define BTN_UP      3
#define BTN_ROBOT   4
#define BTN_SHIP    5

#define NUM_BTN     6

class Retro
{
private:
    
    uint32_t frameStartUs, frameEndUs;
    
private:
    static DigitalIn pin[NUM_BTN];
    uint8_t _state[NUM_BTN];    
        
public:
    uint32_t timePerFrame;
    uint32_t frameDurationUs;

    Sound   sound;
    Display display;
    
    DigitalOut leftEye;
    DigitalOut rightEye;
    
public:
    Retro();
    void initialize();
    bool update();
    
    void setFrameRate(uint8_t fps);        
    static bool collideCheck( int x1, int y1, int w1, int h1, int x2, int y2, int w2, int h2);
    
    void playOK();
    void playCancel();
    void playTick();
    
    void readButtons();
    bool pressed(uint8_t button);
    bool released(uint8_t button);
    bool held(uint8_t button, uint8_t time);
    bool repeat(uint8_t button, uint8_t period);
    uint8_t timeHeld(uint8_t button);
    
};


uint8_t max(uint8_t val1, uint8_t val2 );
uint8_t min(uint8_t val1, uint8_t val2 );

#endif  //__RETRO_H__